<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Confirm Your Early Access Request</title>
    <style>
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Helvetica, Arial, sans-serif;
            line-height: 1.5;
            color: #333;
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
        }
        .content {
            background: #f9f9f9;
            border-radius: 5px;
            padding: 20px;
        }
        .button {
            display: inline-block;
            background-color: #4F46E5;
            color: white;
            text-decoration: none;
            padding: 10px 20px;
            border-radius: 5px;
            margin: 20px 0;
        }
        .footer {
            margin-top: 30px;
            font-size: 0.9em;
            color: #666;
            text-align: center;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>Confirm Your Early Access Request</h1>
    </div>
    
    <div class="content">
        <p>Hello,</p>
        
        <p>Thank you for signing up for early access to our application! We're excited to have you join us.</p>
        
        <p>Please confirm your email address by clicking the button below:</p>
        
        <p style="text-align: center;">
            <a href="{{ url('/verify-early-access/' . $signup->token) }}" class="button">Confirm Email Address</a>
        </p>
        
        <p>If you didn't request this, you can safely ignore this email.</p>
        
        <p>Best regards,<br>The Team</p>
    </div>
    
    <div class="footer">
        <p>This email was sent to {{ $signup->email }}</p>
    </div>
</body>
</html>
