import { Head, Link } from '@inertiajs/react';

export default function SubscriptionError() {
    return (
        <>
            <Head title="Subscription Error" />
            
            <div className="min-h-screen flex flex-col items-center justify-center px-4">
                <div className="max-w-md w-full text-center">
                    <div className="mb-8">
                        <svg 
                            className="mx-auto h-16 w-16 text-red-500"
                            xmlns="http://www.w3.org/2000/svg" 
                            fill="none" 
                            viewBox="0 0 24 24" 
                            strokeWidth={1.5} 
                            stroke="currentColor"
                        >
                            <path strokeLinecap="round" strokeLinejoin="round" d="M12 9v3.75m9-.75a9 9 0 11-18 0 9 9 0 0118 0zm-9 3.75h.008v.008H12v-.008z" />
                        </svg>
                    </div>
                    
                    <h2 className="text-2xl font-bold text-gray-900 dark:text-white mb-2">Subscription Error</h2>
                    <p className="text-gray-600 dark:text-gray-400 mb-8">
                        We couldn't process your subscription request. Please try again or contact support if the problem persists.
                    </p>
                    
                    <div className="flex flex-col space-y-4">
                        <Link
                            href={route('dashboard')}
                            className="w-full py-2 px-4 bg-indigo-600 hover:bg-indigo-700 text-white rounded-md font-medium focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2 dark:focus:ring-offset-gray-900 transition-colors"
                        >
                            Return to Dashboard
                        </Link>
                        
                        <Link
                            href={route('home')}
                            className="w-full py-2 px-4 border border-gray-300 dark:border-gray-600 text-gray-700 dark:text-gray-300 rounded-md font-medium hover:bg-gray-50 dark:hover:bg-gray-800 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2 dark:focus:ring-offset-gray-900 transition-colors"
                        >
                            Back to Home
                        </Link>
                    </div>
                </div>
            </div>
        </>
    );
}
