import React from 'react';
import { Head } from '@inertiajs/react';
import AppLayout from '@/layouts/app-layout';

interface Feature5Props {
  message: string;
}

export default function Feature5({ message }: Feature5Props) {
  return (
    <>
      <Head title="Feature 5 - Premium" />
      <div className="py-12">
        <div className="max-w-7xl mx-auto sm:px-6 lg:px-8">
          <div className="bg-white overflow-hidden shadow-sm sm:rounded-lg">
            <div className="p-6 text-gray-900">
              <h1 className="text-2xl font-bold mb-4">Feature 5 - Premium Feature</h1>
              <div className="bg-purple-100 border-l-4 border-purple-500 text-purple-700 p-4 mb-4">
                <p>{message}</p>
              </div>
              <div className="mt-6">
                <h2 className="text-xl font-semibold mb-2">Premium Feature Description</h2>
                <p className="mb-4">
                  This is an advanced feature available exclusively to Pro plan subscribers.
                </p>
                <div className="bg-gray-100 p-6 rounded-lg">
                  <h3 className="text-lg font-medium mb-2">Premium Functionality</h3>
                  <p className="mb-4">This is a demonstration of Feature 5 premium functionality:</p>
                  <div className="grid grid-cols-1 md:grid-cols-3 gap-4">
                    <div className="border border-gray-200 rounded-md p-4">
                      <h4 className="font-medium mb-2">Advanced Analytics</h4>
                      <div className="h-32 bg-purple-50 flex items-center justify-center">
                        <span className="text-purple-500">Advanced Analytics Dashboard</span>
                      </div>
                    </div>
                    <div className="border border-gray-200 rounded-md p-4">
                      <h4 className="font-medium mb-2">Custom Reports</h4>
                      <div className="h-32 bg-purple-50 flex items-center justify-center">
                        <span className="text-purple-500">Custom Reporting Module</span>
                      </div>
                    </div>
                    <div className="border border-gray-200 rounded-md p-4">
                      <h4 className="font-medium mb-2">AI Insights</h4>
                      <div className="h-32 bg-purple-50 flex items-center justify-center">
                        <span className="text-purple-500">AI-Powered Insights</span>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </>
  );
}

Feature5.layout = (page: React.ReactNode) => <AppLayout children={page} />;
