import React from 'react';
import { Head } from '@inertiajs/react';
import AppLayout from '@/layouts/app-layout';

interface Feature1Props {
  message: string;
}

export default function Feature1({ message }: Feature1Props) {
  return (
    <>
      <Head title="Feature 1 - Basic" />
      <div className="py-12">
        <div className="max-w-7xl mx-auto sm:px-6 lg:px-8">
          <div className="bg-white overflow-hidden shadow-sm sm:rounded-lg">
            <div className="p-6 text-gray-900">
              <h1 className="text-2xl font-bold mb-4">Feature 1 - Basic Feature</h1>
              <div className="bg-green-100 border-l-4 border-green-500 text-green-700 p-4 mb-4">
                <p>{message}</p>
              </div>
              <div className="mt-6">
                <h2 className="text-xl font-semibold mb-2">Feature Description</h2>
                <p className="mb-4">
                  This is a basic feature available to all users with a Starter plan or higher.
                </p>
                <div className="bg-gray-100 p-6 rounded-lg">
                  <h3 className="text-lg font-medium mb-2">Dummy Functionality</h3>
                  <p className="mb-4">This is a demonstration of Feature 1 functionality:</p>
                  <div className="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div className="border border-gray-200 rounded-md p-4">
                      <h4 className="font-medium mb-2">Basic Analytics</h4>
                      <div className="h-32 bg-blue-50 flex items-center justify-center">
                        <span className="text-blue-500">Basic Analytics Dashboard</span>
                      </div>
                    </div>
                    <div className="border border-gray-200 rounded-md p-4">
                      <h4 className="font-medium mb-2">Standard Reports</h4>
                      <div className="h-32 bg-blue-50 flex items-center justify-center">
                        <span className="text-blue-500">Standard Reporting Module</span>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </>
  );
}

Feature1.layout = (page: React.ReactNode) => <AppLayout children={page} />;
