import { PlaceholderPattern } from '@/components/ui/placeholder-pattern';
import AppLayout from '@/layouts/app-layout';
import { type BreadcrumbItem } from '@/types';
import { Head, Link } from '@inertiajs/react';

const breadcrumbs: BreadcrumbItem[] = [
    {
        title: 'Dashboard',
        href: '/dashboard',
    },
];

export default function Dashboard() {
    return (
        <AppLayout breadcrumbs={breadcrumbs}>
            <Head title="Dashboard" />
            <div className="flex h-full flex-1 flex-col gap-4 rounded-xl p-4">
                <h2 className="text-2xl font-bold mb-4">Available Features</h2>
                <div className="grid auto-rows-min gap-4 md:grid-cols-3">
                    <Link href="/features/feature1" className="border-sidebar-border/70 dark:border-sidebar-border relative aspect-video overflow-hidden rounded-xl border group hover:border-blue-500 transition-all duration-300">
                        <div className="absolute inset-0 size-full p-4 flex flex-col justify-between z-10">
                            <div>
                                <h3 className="text-xl font-semibold">Feature 1</h3>
                                <p className="text-sm text-gray-600 dark:text-gray-300">Basic Feature - Starter Plan</p>
                            </div>
                            <div className="bg-blue-100 dark:bg-blue-900/50 px-3 py-1 rounded-lg inline-block w-fit">
                                <span className="text-sm font-medium text-blue-700 dark:text-blue-300">Access Now</span>
                            </div>
                        </div>
                        <div className="absolute inset-0 bg-gradient-to-t from-white/80 to-transparent dark:from-black/50 dark:to-transparent"></div>
                        <PlaceholderPattern className="absolute inset-0 size-full stroke-neutral-900/20 dark:stroke-neutral-100/20" />
                    </Link>
                    <Link href="/features/feature5" className="border-sidebar-border/70 dark:border-sidebar-border relative aspect-video overflow-hidden rounded-xl border group hover:border-purple-500 transition-all duration-300">
                        <div className="absolute inset-0 size-full p-4 flex flex-col justify-between z-10">
                            <div>
                                <h3 className="text-xl font-semibold">Feature 5</h3>
                                <p className="text-sm text-gray-600 dark:text-gray-300">Premium Feature - Pro Plan Only</p>
                            </div>
                            <div className="bg-purple-100 dark:bg-purple-900/50 px-3 py-1 rounded-lg inline-block w-fit">
                                <span className="text-sm font-medium text-purple-700 dark:text-purple-300">Access Now</span>
                            </div>
                        </div>
                        <div className="absolute inset-0 bg-gradient-to-t from-white/80 to-transparent dark:from-black/50 dark:to-transparent"></div>
                        <PlaceholderPattern className="absolute inset-0 size-full stroke-neutral-900/20 dark:stroke-neutral-100/20" />
                    </Link>
                    <div className="border-sidebar-border/70 dark:border-sidebar-border relative aspect-video overflow-hidden rounded-xl border">
                        <div className="absolute inset-0 size-full p-4 flex flex-col justify-between z-10">
                            <div>
                                <h3 className="text-xl font-semibold">More Features</h3>
                                <p className="text-sm text-gray-600 dark:text-gray-300">Coming Soon</p>
                            </div>
                        </div>
                        <div className="absolute inset-0 bg-gradient-to-t from-white/80 to-transparent dark:from-black/50 dark:to-transparent"></div>
                        <PlaceholderPattern className="absolute inset-0 size-full stroke-neutral-900/20 dark:stroke-neutral-100/20" />
                    </div>
                </div>
                <div className="border-sidebar-border/70 dark:border-sidebar-border relative min-h-[50vh] flex-1 overflow-hidden rounded-xl border md:min-h-min p-6">
                    <h2 className="text-xl font-bold mb-4 z-10 relative">Plan-Based Feature Access</h2>
                    <p className="mb-4 z-10 relative">This dashboard demonstrates how different features are restricted based on your subscription plan:</p>
                    
                    <div className="grid md:grid-cols-2 gap-6 z-10 relative">
                        <div className="bg-white dark:bg-gray-800 p-4 rounded-lg shadow">
                            <h3 className="font-semibold text-lg mb-2">Starter Plan</h3>
                            <ul className="list-disc pl-5 space-y-1">
                                <li>Access to Feature 1</li>
                                <li>Basic functionality</li>
                                <li>Standard support</li>
                            </ul>
                        </div>
                        
                        <div className="bg-white dark:bg-gray-800 p-4 rounded-lg shadow">
                            <h3 className="font-semibold text-lg mb-2">Pro Plan</h3>
                            <ul className="list-disc pl-5 space-y-1">
                                <li>Access to Feature 1</li>
                                <li>Access to Feature 5</li>
                                <li>Advanced functionality</li>
                                <li>Priority support</li>
                            </ul>
                        </div>
                    </div>
                    
                    <PlaceholderPattern className="absolute inset-0 size-full stroke-neutral-900/20 dark:stroke-neutral-100/20" />
                </div>
            </div>
        </AppLayout>
    );
}
