import { Link } from '@inertiajs/react';
import { motion } from 'framer-motion';

const HeroSection = () => {
    return (
        <section className="relative overflow-hidden pt-16 md:pt-20 lg:pt-28">
            <div className="container px-4 md:px-6 mx-auto max-w-7xl">
                <div className="grid grid-cols-1 gap-6 lg:grid-cols-2 lg:gap-12 xl:gap-16">
                    <motion.div
                        initial={{ opacity: 0, y: 20 }}
                        animate={{ opacity: 1, y: 0 }}
                        transition={{ duration: 0.7 }}
                        className="flex flex-col justify-center space-y-4">
                        <div className="space-y-2">
                            <div className="inline-block rounded-full bg-indigo-100 px-3 py-1 text-sm font-medium text-indigo-800 dark:bg-indigo-900/30 dark:text-indigo-300">
                                Launching Soon
                            </div>
                            <h1 className="text-4xl font-extrabold tracking-tight sm:text-5xl md:text-6xl font-jakarta bg-clip-text text-transparent bg-gradient-to-r from-indigo-500 to-purple-500 dark:from-indigo-400 dark:to-purple-400">
                                Build Your SaaS Faster Than Ever
                            </h1>
                            <p className="max-w-[600px] text-gray-500 md:text-xl/relaxed lg:text-base/relaxed xl:text-xl/relaxed dark:text-gray-400">
                                The most comprehensive starter kit for SaaS applications. Launch your product in days, not months.
                            </p>
                        </div>
                        <div className="flex flex-col gap-2 min-[400px]:flex-row">
                            <Link
                                href={route('register')}
                                className="inline-flex h-10 items-center justify-center rounded-md bg-indigo-600 px-8 text-sm font-medium text-white shadow-sm transition-colors hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2 dark:focus:ring-offset-gray-950"
                            >
                                Get Started
                            </Link>
                            <Link
                                href="#features"
                                className="inline-flex h-10 items-center justify-center rounded-md border border-gray-200 bg-white px-8 text-sm font-medium shadow-sm transition-colors hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2 dark:border-gray-800 dark:bg-gray-950 dark:hover:bg-gray-800 dark:focus:ring-offset-gray-950"
                            >
                                Learn More
                            </Link>
                        </div>
                    </motion.div>
                    <motion.div
                        initial={{ opacity: 0, scale: 0.9 }}
                        animate={{ opacity: 1, scale: 1 }}
                        transition={{ duration: 0.7, delay: 0.2 }}
                        className="flex items-center justify-center lg:justify-end">
                        <div className="relative w-full max-w-[500px] aspect-[4/3] overflow-hidden rounded-xl border border-gray-200 bg-white p-2 shadow-lg dark:border-gray-800 dark:bg-gray-950">
                            <div className="absolute top-2 left-2 right-2 flex h-6 items-center justify-start space-x-1.5 rounded-t-md bg-gray-100 px-2 dark:bg-gray-900">
                                <div className="h-2 w-2 rounded-full bg-red-500"></div>
                                <div className="h-2 w-2 rounded-full bg-yellow-500"></div>
                                <div className="h-2 w-2 rounded-full bg-green-500"></div>
                            </div>
                            <div className="mt-6 rounded-b-md bg-gray-100 p-4 dark:bg-gray-900">
                                <div className="space-y-3">
                                    <div className="h-2 w-3/5 rounded-lg bg-gray-200 dark:bg-gray-800"></div>
                                    <div className="h-2 w-4/5 rounded-lg bg-gray-200 dark:bg-gray-800"></div>
                                    <div className="h-2 w-2/5 rounded-lg bg-gray-200 dark:bg-gray-800"></div>
                                </div>
                                <div className="mt-6 grid grid-cols-3 gap-4">
                                    <div className="h-20 rounded-md bg-indigo-100 p-2 dark:bg-indigo-900/30">
                                        <div className="h-2 w-8 rounded-lg bg-indigo-200 dark:bg-indigo-700"></div>
                                        <div className="mt-2 h-10 rounded-md bg-indigo-200 dark:bg-indigo-700"></div>
                                    </div>
                                    <div className="h-20 rounded-md bg-purple-100 p-2 dark:bg-purple-900/30">
                                        <div className="h-2 w-8 rounded-lg bg-purple-200 dark:bg-purple-700"></div>
                                        <div className="mt-2 h-10 rounded-md bg-purple-200 dark:bg-purple-700"></div>
                                    </div>
                                    <div className="h-20 rounded-md bg-pink-100 p-2 dark:bg-pink-900/30">
                                        <div className="h-2 w-8 rounded-lg bg-pink-200 dark:bg-pink-700"></div>
                                        <div className="mt-2 h-10 rounded-md bg-pink-200 dark:bg-pink-700"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </motion.div>
                </div>
            </div>
        </section>
    );
};

export default HeroSection;
