import React from 'react';

type BillingToggleProps = {
    billingInterval: 'monthly' | 'yearly';
    setBillingInterval: (interval: 'monthly' | 'yearly') => void;
    yearlySavingsPercentage: number;
};

const BillingToggle: React.FC<BillingToggleProps> = ({ 
    billingInterval, 
    setBillingInterval,
    yearlySavingsPercentage
}) => {
    return (
        <div className="mb-8 flex items-center justify-center bg-gray-100 dark:bg-gray-800 rounded-full p-1.5 w-80 mx-auto">
            <button
                onClick={() => setBillingInterval('monthly')}
                className={`flex-1 text-center rounded-full py-2 px-4 text-sm font-medium transition-all ${
                    billingInterval === 'monthly'
                        ? 'bg-white dark:bg-gray-700 shadow text-gray-900 dark:text-white'
                        : 'text-gray-600 dark:text-gray-300 hover:text-gray-800 dark:hover:text-gray-100'
                }`}
            >
                Monthly
            </button>
            <button
                onClick={() => setBillingInterval('yearly')}
                className={`flex-1 text-center rounded-full py-2 px-4 text-sm font-medium transition-all ${
                    billingInterval === 'yearly'
                        ? 'bg-white dark:bg-gray-700 shadow text-gray-900 dark:text-white'
                        : 'text-gray-600 dark:text-gray-300 hover:text-gray-800 dark:hover:text-gray-100'
                }`}
            >
                Yearly
                <span className="ml-1 text-xs text-green-600 dark:text-green-400">Save {yearlySavingsPercentage}%</span>
            </button>
        </div>
    );
};

export default BillingToggle;
