import { Link } from '@inertiajs/react';

const Footer = () => {
    return (
        <footer className="border-t border-gray-200 bg-white py-12 dark:border-gray-800 dark:bg-gray-950">
            <div className="container px-4 md:px-6 mx-auto max-w-7xl">
                <div className="grid grid-cols-1 gap-8 md:grid-cols-2 lg:grid-cols-4">
                    <div className="space-y-4">
                        <div className="flex items-center gap-2">
                            <div className="h-8 w-8 rounded-lg bg-indigo-600 flex items-center justify-center text-white font-bold">SL</div>
                            <span className="text-xl font-bold tracking-tight font-jakarta">SaaSLarkit</span>
                        </div>
                        <p className="text-sm text-gray-500 dark:text-gray-400">
                            The complete SaaS starter kit for your next big idea.
                        </p>
                    </div>
                    <div className="space-y-4">
                        <h3 className="text-sm font-semibold">Product</h3>
                        <ul className="space-y-2">
                            <li>
                                <Link href="#features" className="text-sm text-gray-500 hover:text-gray-900 dark:text-gray-400 dark:hover:text-gray-50">
                                    Features
                                </Link>
                            </li>
                            <li>
                                <Link href="#pricing" className="text-sm text-gray-500 hover:text-gray-900 dark:text-gray-400 dark:hover:text-gray-50">
                                    Pricing
                                </Link>
                            </li>
                            <li>
                                <Link href="#testimonials" className="text-sm text-gray-500 hover:text-gray-900 dark:text-gray-400 dark:hover:text-gray-50">
                                    Testimonials
                                </Link>
                            </li>
                        </ul>
                    </div>
                    <div className="space-y-4">
                        <h3 className="text-sm font-semibold">Company</h3>
                        <ul className="space-y-2">
                            <li>
                                <Link href="#" className="text-sm text-gray-500 hover:text-gray-900 dark:text-gray-400 dark:hover:text-gray-50">
                                    About
                                </Link>
                            </li>
                            <li>
                                <Link href="#" className="text-sm text-gray-500 hover:text-gray-900 dark:text-gray-400 dark:hover:text-gray-50">
                                    Blog
                                </Link>
                            </li>
                            <li>
                                <Link href="#" className="text-sm text-gray-500 hover:text-gray-900 dark:text-gray-400 dark:hover:text-gray-50">
                                    Careers
                                </Link>
                            </li>
                        </ul>
                    </div>
                    <div className="space-y-4">
                        <h3 className="text-sm font-semibold">Legal</h3>
                        <ul className="space-y-2">
                            <li>
                                <Link href={route('pages.show', 'privacy-policy')} className="text-sm text-gray-500 hover:text-gray-900 dark:text-gray-400 dark:hover:text-gray-50">
                                    Privacy Policy
                                </Link>
                            </li>
                            <li>
                                <Link href={route('pages.show', 'terms-of-service')} className="text-sm text-gray-500 hover:text-gray-900 dark:text-gray-400 dark:hover:text-gray-50">
                                    Terms of Service
                                </Link>
                            </li>
                        </ul>
                    </div>
                </div>
                <div className="mt-8 border-t border-gray-200 pt-8 dark:border-gray-800">
                    <p className="text-sm text-gray-500 dark:text-gray-400">
                        © {new Date().getFullYear()} SaaSLarkit. All rights reserved.
                    </p>
                </div>
            </div>
        </footer>
    );
};

export default Footer;
