<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class LemonSqueezySubscription extends Model
{
    protected $table = 'lemon_squeezy_subscriptions';
    
    protected $casts = [
        'renews_at' => 'datetime',
        'ends_at' => 'datetime',
        'trial_ends_at' => 'datetime',
        'pause_resumes_at' => 'datetime',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];
    
    /**
     * Get the billable model (user) that owns the subscription.
     */
    public function billable(): BelongsTo
    {
        return $this->belongsTo(User::class, 'billable_id');
    }
    
    /**
     * Get the plan associated with this subscription.
     */
    public function plan(): BelongsTo
    {
        return $this->belongsTo(Plan::class, 'variant_id', 'lemonsqueezy_price_id');
    }
    
    /**
     * Scope a query to only include active subscriptions.
     */
    public function scopeActive($query)
    {
        return $query->where('status', 'active');
    }
}
