<?php

namespace App\Mail;

use App\Models\EarlyAccessSignup;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class EarlyAccessConfirmation extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * The early access signup instance.
     *
     * @var \App\Models\EarlyAccessSignup
     */
    public $signup;

    /**
     * Create a new message instance.
     */
    public function __construct(EarlyAccessSignup $signup)
    {
        $this->signup = $signup;
    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        return new Envelope(
            subject: 'Confirm Your Early Access Request',
        );
    }

    /**
     * Get the message content definition.
     */
    public function content(): Content
    {
        return new Content(
            view: 'emails.early-access-confirmation',
        );
    }

    /**
     * Get the attachments for the message.
     *
     * @return array<int, \Illuminate\Mail\Mailables\Attachment>
     */
    public function attachments(): array
    {
        return [];
    }
}
