<?php

namespace App\Filament\Widgets;

use App\Models\User;
use App\Models\Plan;
use App\Models\LemonSqueezySubscription;
use Filament\Tables;
use Filament\Tables\Table;
use Filament\Widgets\TableWidget as BaseWidget;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class LatestSubscriptionsWidget extends BaseWidget
{
    protected static ?int $sort = 3;
    
    protected int | string | array $columnSpan = 'full';
    
    protected function getTableHeading(): string
    {
        return 'Latest Subscriptions';
    }
    
    public function table(Table $table): Table
    {
        return $table
            ->query(
                LemonSqueezySubscription::query()
                ->select(
                    'lemon_squeezy_subscriptions.*',
                    'users.name as user_name',
                    'users.email as user_email',
                    'plans.name as plan_name',
                    'plans.price_cents',
                    'plans.billing_interval'
                )
                ->join('users', 'users.id', '=', 'lemon_squeezy_subscriptions.billable_id')
                ->leftJoin('plans', 'plans.lemonsqueezy_price_id', '=', 'lemon_squeezy_subscriptions.variant_id')
                ->where('lemon_squeezy_subscriptions.billable_type', 'App\\Models\\User')
                ->orderBy('lemon_squeezy_subscriptions.created_at', 'desc')
                ->limit(10)
            )
            ->columns([
                Tables\Columns\TextColumn::make('user_name')
                    ->label('User')
                    ->searchable(),
                Tables\Columns\TextColumn::make('user_email')
                    ->label('Email')
                    ->searchable(),
                Tables\Columns\TextColumn::make('plan_name')
                    ->label('Plan')
                    ->searchable(),
                Tables\Columns\TextColumn::make('price_cents')
                    ->label('Price')
                    ->formatStateUsing(fn ($state) => '$' . number_format($state / 100, 2)),
                Tables\Columns\TextColumn::make('billing_interval')
                    ->label('Billing')
                    ->formatStateUsing(fn ($state) => ucfirst($state)),
                Tables\Columns\TextColumn::make('status')
                    ->badge()
                    ->color(fn (string $state): string => match ($state) {
                        'active' => 'success',
                        'cancelled' => 'danger',
                        'past_due' => 'warning',
                        default => 'gray',
                    }),
                Tables\Columns\TextColumn::make('created_at')
                    ->label('Created')
                    ->dateTime()
                    ->sortable(),
                Tables\Columns\TextColumn::make('renews_at')
                    ->label('Renews')
                    ->dateTime()
                    ->sortable(),
            ])
            ->filters([
                // 
            ])
            ->actions([
                // 
            ])
            ->bulkActions([
                // 
            ]);
    }
}
