<?php

namespace App\Filament\Exports;

use App\Models\EarlyAccessSignup;
use Filament\Actions\Exports\ExportColumn;
use Filament\Actions\Exports\Exporter;
use Filament\Actions\Exports\Models\Export;

class EarlyAccessSignupExporter extends Exporter
{
    protected static ?string $model = EarlyAccessSignup::class;

    public static function getColumns(): array
    {
        return [
            ExportColumn::make('id'),
            ExportColumn::make('email'),
            ExportColumn::make('is_verified')
                ->label('Verified')
                ->state(fn (EarlyAccessSignup $record): string => $record->is_verified ? 'Yes' : 'No'),
            ExportColumn::make('signed_up_at')
                ->label('Signed Up At'),
            ExportColumn::make('verified_at')
                ->label('Verified At'),
            ExportColumn::make('created_at'),
            ExportColumn::make('updated_at'),
        ];
    }

    public static function getCompletedNotificationBody(Export $export): string
    {
        $body = 'Your email leads export has completed and ' . number_format($export->successful_rows) . ' ' . str('row')->plural($export->successful_rows) . ' exported.';

        if ($failedRowsCount = $export->getFailedRowsCount()) {
            $body .= ' ' . number_format($failedRowsCount) . ' ' . str('row')->plural($failedRowsCount) . ' failed to export.';
        }

        return $body;
    }
}
