<?php

use Illuminate\Foundation\Inspiring;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Schedule;

Artisan::command('inspire', function () {
    $this->comment(Inspiring::quote());
})->purpose('Display an inspiring quote');

// Get all accounts except 'default'
$nonDefaultAccounts = collect(config('imap.accounts', []))
    ->except('default')  // Exclude default
    ->filter(function ($account) {
        // Only include properly configured accounts
        return !empty($account['username']) &&
               !empty($account['password']) &&
               $account['host'] !== 'localhost';
    })
    ->keys();

// Only schedule if there are non-default accounts configured
if ($nonDefaultAccounts->isNotEmpty()) {
    Schedule::command('emails:fetch', ['--account' => $nonDefaultAccounts->implode(',')])
        ->everyTwoMinutes()
        ->withoutOverlapping()
        ->runInBackground();
}
// Schedule log pruning based on retention settings
Schedule::command('logs:prune')
    ->daily()
    ->runInBackground()
    ->withoutOverlapping()
    ->name('logs:prune')
    ->description('Prune application logs older than the configured retention period')
    ->when(fn () => (int) config('ticaga.logs.retention_days', 30) !== 0);

    // Schedule log clearing weekly
    Schedule::command('log:clear')->weeklyOn(1, '01:00');
