<?php
use App\Http\Controllers\Api\Two\{ApiController, ApiCustomers, ApiTickets, ApiResponses, ApiDepartments};
use Illuminate\Support\Facades\{Route, Requests};

if(Config::get('ticaga.api') == 'v1')
{
    // API v1 is defunct - return 410 Gone for all requests
    Route::any('{any}', function () {
        return response()->json([
            'error' => 'API v1 is no longer available',
            'message' => 'API v1 has been deprecated and removed. Please upgrade to v2.',
            'current_version' => 'v2',
            'status' => 410
        ], 410);
    })->where('any', '.*');
}

if(Config::get('ticaga.api') == 'v2')
{
    // Global rate limit applied to all API endpoints
    Route::middleware(['throttle:api-global'])->group(function () {
        
        // Authentication endpoints - strict rate limiting (5 req/min)
        Route::middleware(['throttle:auth'])->group(function () {
            Route::post('register', [ApiCustomers::class, 'register']);
            Route::post('login', [ApiController::class, 'login']);
            Route::post('logout', [ApiController::class, 'logout']);
        });

        // Connection validation - general API limit
        Route::middleware(['throttle:api'])->group(function () {
            Route::post('connection', [ApiController::class, 'connection']);
        });

        // Read-only endpoints - higher rate limits (100 req/min)
        Route::middleware(['throttle:api-read'])->group(function () {
            // Customers - Read operations
            Route::get('customers/get/{id}', [ApiCustomers::class, 'getUser']);
            
            // Tickets - Read operations
            Route::post('tickets/info/', [ApiTickets::class, 'getTicketInfo']);
            Route::post('tickets/get', [ApiTickets::class, 'getTicket']);
            Route::get('tickets/get/all/{id}', [ApiTickets::class, 'getTickets']);
            Route::get('tickets/get/{id}/{ticket_id}', [ApiTickets::class, 'getTicket']);
            
            // Responses - Read operations
            Route::post('responses/get', [ApiResponses::class, 'getResponses']);
            Route::get('responses/get/{ticket_id}', [ApiResponses::class, 'getResponses']);
            
            // Departments - Read operations
            Route::get('departments/{type}', [ApiDepartments::class, 'getDepartments']);
            Route::get('departments/get/{slug}', [ApiDepartments::class, 'getDepartmentSlug']);
            Route::get('departments/get_by_id/{id}', [ApiDepartments::class, 'getDepartment']);
        });

        // Write endpoints - stricter rate limits (30 req/min)
        Route::middleware(['throttle:api-write'])->group(function () {
            // Customers - Write operations
            Route::post('customers/assign', [ApiCustomers::class, 'assignUser']);
            
            // Tickets - Write operations
            Route::post('tickets/create', [ApiTickets::class, 'store']);
            
            // Responses - Write operations
            Route::post('responses/create', [ApiResponses::class, 'store']);
        });

        // Authenticated API routes (additional protection)
        Route::middleware('auth:api')->group(function () {
            // Add authenticated-only routes here
        });
    });
}
