<x-layouts.app :title="__('Viewing Ticket')">
    <flux:heading size="xl" level="1">
        {{ $ticket->subject }}
        @hasanyrole('superadmin|employee|admin')
            <button id="dropdownMenuIconHorizontalButton" data-dropdown-toggle="dropdownDotsHorizontal" class="inline-flex items-center p-2 text-sm font-medium text-center text-gray-900 bg-white rounded-lg hover:bg-gray-100 focus:ring-4 focus:outline-none dark:text-white focus:ring-gray-50 dark:bg-gray-900 dark:hover:bg-gray-700 dark:focus:ring-gray-600" type="button"> 
                <svg class="w-5 h-5" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 16 3">
                    <path d="M2 0a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3Zm6.041 0a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3ZM14 0a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3Z"/>
                </svg>
            </button>
            <div id="dropdownDotsHorizontal" class="z-10 hidden bg-white divide-y divide-gray-100 rounded-lg shadow-sm w-44 dark:bg-gray-700 dark:divide-gray-600">
                <ul class="py-2 text-sm text-gray-700 dark:text-gray-200" aria-labelledby="dropdownMenuIconHorizontalButton">
                    <li>
                        @hasanyrole('superadmin|admin')
                        <a href="#" data-modal-target="change-customer-modal" data-modal-toggle="change-customer-modal" class="block px-4 py-2 hover:bg-gray-100 dark:hover:bg-gray-600 dark:hover:text-white">
                            {{ __("Change Customer") }}
                        </a>
                        @endhasanyrole
                        <a href="#" data-modal-target="change-status-modal" data-modal-toggle="change-status-modal" class="block px-4 py-2 hover:bg-gray-100 dark:hover:bg-gray-600 dark:hover:text-white">
                            {{ __("Change Status") }}
                        </a>
                        <a href="#" data-modal-target="change-priority-modal" data-modal-toggle="change-priority-modal" class="block px-4 py-2 hover:bg-gray-100 dark:hover:bg-gray-600 dark:hover:text-white">
                            {{ __("Change Priority") }}
                        </a>
                        <a href="#" data-modal-target="change-department-modal" data-modal-toggle="change-department-modal" class="block px-4 py-2 hover:bg-gray-100 dark:hover:bg-gray-600 dark:hover:text-white">
                            {{ __("Change Department") }}
                        </a>
                        @hasanyrole('superadmin|admin')
                        <a href="#" data-modal-target="change-assign-modal" data-modal-toggle="change-assign-modal" class="block px-4 py-2 hover:bg-gray-100 dark:hover:bg-gray-600 dark:hover:text-white">
                            {{ __("Assign an Employee") }}
                        </a>
                        @endhasanyrole
                    </li>
            </div>
        @endhasanyrole
    </flux:heading>
    <div class="flex items-center justify-between mt-2">
        <livewire:tickets.close :ticket_id="$ticket->ticket_id"/>
        <livewire:tickets.rating :ticket_id="$ticket->ticket_id" :public_hash="$ticket->public_hash ?? null"/>
    </div>
    <flux:separator variant="subtle" class="mt-3" />

    {{-- Current Viewers Display --}}
    @hasanyrole('superadmin|admin|employee')
        <livewire:tickets.current-viewers :ticket_id="$ticket->ticket_id"/>
    @endhasanyrole
    <div class="flex w-full flex-1 flex-col gap-4 rounded-xl mt-3">
        <div class="grid auto-rows-min gap-4 md:grid-cols-3">
            <div class="rounded-xl text-gray-900! dark:text-white">
                <x-mary-stat
                    title="{{ __('Department') }}"
                    value="{{ $ticket->department_name }}"
                    icon="o-chat-bubble-left-ellipsis"
                    color="text-primary dark:text-white"
                    class="!bg-white border border-neutral-200 rounded-lg shadow-sm p-8 dark:!text-white dark:!bg-gray-900 dark:border-neutral-700" />
            </div>
            <div class="rounded-xl text-gray-900! dark:text-white">
                <x-mary-stat
                    title="{{ __('Status') }}"
                    value="{{ ucfirst($ticket->status->label()) }}"
                    icon="o-chat-bubble-left-right"
                    color="text-primary dark:text-white"
                    class="!bg-white border border-neutral-200 rounded-lg shadow-sm p-8 dark:!text-white dark:!bg-gray-900 dark:border-neutral-700" />
            </div>
            <div class="rounded-xl text-gray-900! dark:text-white">
                <x-mary-stat
                    title="{{ __('Priority') }}"
                    value="{{ ucfirst($ticket->priority->label()) }}"
                    icon="o-shield-exclamation"
                    color="text-primary dark:text-white"
                    class="!bg-white border border-neutral-200 rounded-lg shadow-sm p-8 dark:!text-white dark:!bg-gray-900 dark:border-neutral-700" />
            </div>
        </div>
    </div>
    @if($ticket->date_closed != null && $ticket->status = 'closed')
    <div class="p-4 mb-4 mt-4 text-sm text-red-800 bg-red-50 border border-red-300 rounded-lg dark:shadow-sm dark:bg-gray-900 dark:text-white dark:border-neutral-700" role="alert">
        {{ __("This ticket has been closed.") }}
    </div>
    @endif
    <div class="mt-3">
        @if(config('ticaga.design') == 'modern')
        <div class="max-w-7xl mx-auto overflow-x-auto bg-white border border-neutral-200 rounded-lg shadow-sm p-8 dark:text-white dark:bg-gray-900 dark:border-neutral-700 p-5">
            <div class="flex items-start gap-2.5">
                @if(!Auth::guest() && !empty($customer->profile_photo_path))
                    <img class="w-8 h-8 rounded-full"
                        src="{{ config('app.url') }}/storage/{{ $ticket->profile_photo_path }}"
                        alt="{{ $ticket->name }}" />
                @else
                    <img class="w-8 h-8 rounded-full"
                        src="@php echo "https://gravatar.com/avatar/". hash('sha256', strtolower(trim($ticket->email ?? $ticket->public_email))).".png?default=monsterid"; @endphp"
                        alt="{{ $ticket->name ?? $ticket->public_name }}"/>
                @endif
                <div class="flex flex-col w-full max-w-[450px] leading-1.5 p-4 border-gray-200 bg-gray-100 rounded-e-xl rounded-es-xl dark:bg-gray-700">
                    <div class="flex items-center space-x-2 rtl:space-x-reverse">
                        <span class="text-sm font-semibold text-gray-900 dark:text-white">
                            @if($ticket->user_id != '0')
                                <a href="/clients/view/{{ $ticket->user_id }}">
                                    {{ $ticket->client_name }}
                                </a> 
                            @else
                                {{ $ticket->public_name }}
                            @endif
                        </span>
                        <span class="text-sm font-normal text-gray-500 dark:text-gray-400">
                            {{ Carbon\Carbon::parse($ticket->ticket_created)->format('jS F Y H:i') }}
                        </span>
                    </div>
                    <p class="text-sm font-normal text-gray-900 dark:text-white whitespace-pre-line">
                        {!! Str::of($ticket->message)->inlinemarkdown(['html_input' => 'strip', 'allow_unsafe_links' => false,]) !!}
                    </p>

                    {{-- Attachments --}}
                    @if($ticketAttachments && $ticketAttachments->count() > 0)
                    <div class="mt-2 pt-2 border-t border-gray-300 dark:border-gray-600">
                        <div class="flex flex-wrap gap-2">
                            @foreach($ticketAttachments as $attachment)
                                @if($attachment->isImage())
                                    {{-- Image attachment - show inline --}}
                                    <div class="group relative">
                                        <a href="{{ route('attachments.view', $attachment->id) }}"
                                           target="_blank"
                                           class="block rounded-md overflow-hidden border-2 border-gray-300 dark:border-gray-500 hover:border-indigo-500 dark:hover:border-indigo-400 transition-all">
                                            <img src="{{ $attachment->getThumbnailUrl() ?? route('attachments.view', $attachment->id) }}"
                                                 alt="{{ $attachment->original_filename }}"
                                                 class="max-w-xs max-h-48 object-contain bg-white dark:bg-gray-800"
                                                 loading="lazy">
                                        </a>
                                        <div class="mt-1 text-xs text-gray-600 dark:text-gray-300">
                                            <span>{{ $attachment->original_filename }}</span>
                                            <span class="text-gray-500 dark:text-gray-400">({{ \App\Services\AttachmentService::formatBytes($attachment->size) }})</span>
                                        </div>
                                    </div>
                                @else
                                    {{-- Non-image attachment - show download link --}}
                                    <a href="{{ route('attachments.download', $attachment->id) }}"
                                       class="inline-flex items-center gap-1.5 px-2.5 py-1.5 text-xs font-medium text-gray-700 dark:text-gray-200 bg-white dark:bg-gray-600 border border-gray-300 dark:border-gray-500 rounded-md hover:bg-gray-50 dark:hover:bg-gray-500 transition-colors">
                                        <svg class="w-3.5 h-3.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15.172 7l-6.586 6.586a2 2 0 102.828 2.828l6.414-6.586a4 4 0 00-5.656-5.656l-6.415 6.585a6 6 0 108.486 8.486L20.5 13"></path>
                                        </svg>
                                        <span>{{ $attachment->original_filename }}</span>
                                        <span class="text-gray-500 dark:text-gray-400">({{ \App\Services\AttachmentService::formatBytes($attachment->size) }})</span>
                                    </a>
                                @endif
                            @endforeach
                        </div>
                    </div>
                    @endif

                    @hasanyrole('superadmin|employee|admin')
                        <span class="text-sm font-normal text-gray-500 dark:text-gray-400">
                            {{ $ticket->ip_address }}@if(!$ticket->organize->isTicket()) - {{ __('Type') }}: {{ $ticket->organize->label() }}@endif
                        </span>
                    @endhasanyrole
                </div>
            </div>
                
            <div>
                <livewire:tickets.responses :ticket_id="$ticket->ticket_id"/>
            </div>
        </div>
        @else
            <div class="max-w-7xl mx-auto overflow-x-auto bg-white border border-neutral-200 rounded-lg shadow-sm dark:text-white dark:bg-gray-900 dark:border-neutral-700 p-1">
                <div class="border-b-1 border-neutral-200 dark:border-neutral-700 grid grid-cols-1 md:grid-cols-4 gap-4 px-3">
                    <div class="mb-2 mt-1 flex items-center">
                        <div class="flex items-center gap-2 sm:gap-4">
                            @php
                                $customer = \App\Models\User::find($ticket->user_id);
                                if($customer)
                                {
                                    $customer_role = $customer->roles->pluck('name')[0];
                                } else {
                                    $customer_role = '';
                                }
            
                                if($customer_role)
                                {
                                    if($customer_role == 'superadmin') {
                                        $role = "Senior Management";
                                    } elseif($customer_role == 'admin') {
                                        $role = "Management";
                                    } elseif($customer_role == 'employee') {
                                        $role = "Employee";
                                    } elseif($customer_role == 'customer') {
                                        $role = "Customer";
                                    } else {
                                        $role = "Guest";
                                    }
                                } else {
                                    $role = "Guest";
                                }
                                if(!Auth::guest() && !empty($customer->profile_photo_path))
                                {
                                    $avatar = asset('storage/' . $customer->profile_photo_path);
                                } else {
                                    $avatar = "https://gravatar.com/avatar/". hash('sha256', strtolower(trim($customer->email ?? $ticket->public_email))).".png?default=monsterid";
                                }
                            @endphp
                            <flux:avatar size="lg" class="max-sm:size-8" src="{{ $avatar }}" />
                        
                            <div class="flex flex-col">
                                <flux:heading><a href="{{ route('view_client',[$ticket->user_id] ) }}">{{  $ticket->name ?? $ticket->public_name }}</a> 
                                @auth 
                                    @if($ticket->user_id == Auth::user()->id)
                                        <x-mary-badge value="You" class="badge-info badge-sm rounded-sm" />
                                    @endif
                                @endauth
                                </flux:heading>
                                <flux:text>{{ $role }} @if(!$ticket->organize->isTicket())<small>via {{ $ticket->organize->label() }}</small>@endif</flux:text>
                            </div>
                        </div>
                    </div>
                    <div class="col-span-3 text-left sm:text-right sm:my-auto text-gray-900 dark:text-white">
                        <flux:text class="mb-2">{{ Carbon\Carbon::parse($ticket->ticket_created)->format('jS F Y H:i') }}</flux:text>
                    </div>
                </div>
                <div class="px-3">
                    <p class="text-sm font-normal text-gray-900 dark:text-white whitespace-pre-line">
                        {!! Str::of($ticket->message)->inlinemarkdown(['html_input' => 'strip', 'allow_unsafe_links' => false,]) !!}
                    </p>

                    {{-- Attachments --}}
                    @if($ticketAttachments && $ticketAttachments->count() > 0)
                    <div class="mt-3 pt-3 border-t border-gray-200 dark:border-gray-700">
                        <div class="flex flex-wrap gap-2">
                            @foreach($ticketAttachments as $attachment)
                                @if($attachment->isImage())
                                    {{-- Image attachment - show inline --}}
                                    <div class="group relative">
                                        <a href="{{ route('attachments.view', $attachment->id) }}"
                                           target="_blank"
                                           class="block rounded-md overflow-hidden border-2 border-gray-300 dark:border-gray-600 hover:border-indigo-500 dark:hover:border-indigo-400 transition-all">
                                            <img src="{{ $attachment->getThumbnailUrl() ?? route('attachments.view', $attachment->id) }}"
                                                 alt="{{ $attachment->original_filename }}"
                                                 class="max-w-xs max-h-48 object-contain bg-white dark:bg-gray-800"
                                                 loading="lazy">
                                        </a>
                                        <div class="mt-1 text-xs text-gray-600 dark:text-gray-300">
                                            <span>{{ $attachment->original_filename }}</span>
                                            <span class="text-gray-500 dark:text-gray-400">({{ \App\Services\AttachmentService::formatBytes($attachment->size) }})</span>
                                        </div>
                                    </div>
                                @else
                                    {{-- Non-image attachment - show download link --}}
                                    <a href="{{ route('attachments.download', $attachment->id) }}"
                                       class="inline-flex items-center gap-1.5 px-2.5 py-1.5 text-xs font-medium text-gray-700 dark:text-gray-200 bg-gray-50 dark:bg-gray-800 border border-gray-300 dark:border-gray-600 rounded-md hover:bg-gray-100 dark:hover:bg-gray-700 transition-colors">
                                        <svg class="w-3.5 h-3.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15.172 7l-6.586 6.586a2 2 0 102.828 2.828l6.414-6.586a4 4 0 00-5.656-5.656l-6.415 6.585a6 6 0 108.486 8.486L20.5 13"></path>
                                        </svg>
                                        <span>{{ $attachment->original_filename }}</span>
                                        <span class="text-gray-500 dark:text-gray-400">({{ \App\Services\AttachmentService::formatBytes($attachment->size) }})</span>
                                    </a>
                                @endif
                            @endforeach
                        </div>
                    </div>
                    @endif
                </div>
            </div>

            <livewire:tickets.responses :ticket_id="$ticket->ticket_id"/>
        @endif

        {{-- Typing Indicator --}}
        <div class="mt-5">
            <livewire:tickets.typing-indicator :ticket_id="$ticket->ticket_id"/>
        </div>

        <div class="mt-5">
            <div class="max-w-7xl mx-auto bg-white border border-neutral-200 rounded-lg shadow-sm dark:bg-gray-900 dark:border-neutral-700">
                <div class="flex items-center gap-3 px-8 py-5 border-b border-gray-200 dark:border-gray-700">
                    <div class="p-2.5 bg-indigo-50 dark:bg-indigo-900/30 rounded-lg">
                        <svg class="w-5 h-5 text-indigo-600 dark:text-indigo-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h10a8 8 0 018 8v2M3 10l6 6m-6-6l6-6"></path>
                        </svg>
                    </div>
                    <div>
                        <h2 class="text-lg font-semibold text-gray-900 dark:text-white">Add Response</h2>
                        <p class="text-sm text-gray-500 dark:text-gray-400">Reply to this ticket or add a private note</p>
                    </div>
                </div>
                <div class="p-8">
                    <livewire:tickets.comments :ticket_id="$ticket->ticket_id"/>
                </div>
            </div>
        </div>
    </div>

    <div id="change-customer-modal" tabindex="-1" aria-hidden="true" class="hidden overflow-y-auto overflow-x-hidden fixed top-0 right-0 left-0 z-50 justify-center items-center w-full md:inset-0 h-[calc(100%-1rem)] max-h-full">
        <div class="relative p-4 w-full max-w-md max-h-full">
            <!-- Modal content -->
            <div class="relative bg-white rounded-lg shadow-sm dark:bg-gray-700">
                <!-- Modal header -->
                <div class="flex items-center justify-between p-4 md:p-5 border-b rounded-t dark:border-gray-600 border-gray-200">
                    <h3 class="text-xl font-semibold text-gray-900 dark:text-white">
                        Change Customer
                    </h3>
                    <button type="button" class="end-2.5 text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm w-8 h-8 ms-auto inline-flex justify-center items-center dark:hover:bg-gray-600 dark:hover:text-white" data-modal-hide="change-customer-modal">
                        <svg class="w-3 h-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 14 14">
                            <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6"/>
                        </svg>
                        <span class="sr-only">Close modal</span>
                    </button>
                </div>
                <!-- Modal body -->
                <div class="p-4 md:p-5">
                    <livewire:partials.tickets.change_customer :ticket_id="$ticket->ticket_id"/>
                </div>
            </div>
        </div>
    </div> 
    <div id="change-status-modal" tabindex="-1" aria-hidden="true" class="hidden overflow-y-auto overflow-x-hidden fixed top-0 right-0 left-0 z-50 justify-center items-center w-full md:inset-0 h-[calc(100%-1rem)] max-h-full">
        <div class="relative p-4 w-full max-w-md max-h-full">
            <!-- Modal content -->
            <div class="relative bg-white rounded-lg shadow-sm dark:bg-gray-700">
                <!-- Modal header -->
                <div class="flex items-center justify-between p-4 md:p-5 border-b rounded-t dark:border-gray-600 border-gray-200">
                    <h3 class="text-xl font-semibold text-gray-900 dark:text-white">
                        Change Status
                    </h3>
                    <button type="button" class="end-2.5 text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm w-8 h-8 ms-auto inline-flex justify-center items-center dark:hover:bg-gray-600 dark:hover:text-white" data-modal-hide="change-status-modal">
                        <svg class="w-3 h-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 14 14">
                            <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6"/>
                        </svg>
                        <span class="sr-only">Close modal</span>
                    </button>
                </div>
                <!-- Modal body -->
                <div class="p-4 md:p-5">
                    <livewire:partials.tickets.change_status :ticket_id="$ticket->ticket_id"/>
                </div>
            </div>
        </div>
    </div>
    <div id="change-priority-modal" tabindex="-1" aria-hidden="true" class="hidden overflow-y-auto overflow-x-hidden fixed top-0 right-0 left-0 z-50 justify-center items-center w-full md:inset-0 h-[calc(100%-1rem)] max-h-full">
        <div class="relative p-4 w-full max-w-md max-h-full">
            <!-- Modal content -->
            <div class="relative bg-white rounded-lg shadow-sm dark:bg-gray-700">
                <!-- Modal header -->
                <div class="flex items-center justify-between p-4 md:p-5 border-b rounded-t dark:border-gray-600 border-gray-200">
                    <h3 class="text-xl font-semibold text-gray-900 dark:text-white">
                        Change Priority
                    </h3>
                    <button type="button" class="end-2.5 text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm w-8 h-8 ms-auto inline-flex justify-center items-center dark:hover:bg-gray-600 dark:hover:text-white" data-modal-hide="change-priority-modal">
                        <svg class="w-3 h-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 14 14">
                            <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6"/>
                        </svg>
                        <span class="sr-only">Close modal</span>
                    </button>
                </div>
                <!-- Modal body -->
                <div class="p-4 md:p-5">
                    <livewire:partials.tickets.change_priority :ticket_id="$ticket->ticket_id"/>
                </div>
            </div>
        </div>
    </div>
    <div id="change-department-modal" tabindex="-1" aria-hidden="true" class="hidden overflow-y-auto overflow-x-hidden fixed top-0 right-0 left-0 z-50 justify-center items-center w-full md:inset-0 h-[calc(100%-1rem)] max-h-full">
        <div class="relative p-4 w-full max-w-md max-h-full">
            <!-- Modal content -->
            <div class="relative bg-white rounded-lg shadow-sm dark:bg-gray-700">
                <!-- Modal header -->
                <div class="flex items-center justify-between p-4 md:p-5 border-b rounded-t dark:border-gray-600 border-gray-200">
                    <h3 class="text-xl font-semibold text-gray-900 dark:text-white">
                        Change Department
                    </h3>
                    <button type="button" class="end-2.5 text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm w-8 h-8 ms-auto inline-flex justify-center items-center dark:hover:bg-gray-600 dark:hover:text-white" data-modal-hide="change-department-modal">
                        <svg class="w-3 h-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 14 14">
                            <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6"/>
                        </svg>
                        <span class="sr-only">Close modal</span>
                    </button>
                </div>
                <!-- Modal body -->
                <div class="p-4 md:p-5">
                    <livewire:partials.tickets.change_department :ticket_id="$ticket->ticket_id"/>
                </div>
            </div>
        </div>
    </div>
    <div id="change-assign-modal" tabindex="-1" aria-hidden="true" class="hidden overflow-y-auto overflow-x-hidden fixed top-0 right-0 left-0 z-50 justify-center items-center w-full md:inset-0 h-[calc(100%-1rem)] max-h-full">
        <div class="relative p-4 w-full max-w-md max-h-full">
            <!-- Modal content -->
            <div class="relative bg-white rounded-lg shadow-sm dark:bg-gray-700">
                <!-- Modal header -->
                <div class="flex items-center justify-between p-4 md:p-5 border-b rounded-t dark:border-gray-600 border-gray-200">
                    <h3 class="text-xl font-semibold text-gray-900 dark:text-white">
                        Assign ticket to an Employee
                    </h3>
                    <button type="button" class="end-2.5 text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm w-8 h-8 ms-auto inline-flex justify-center items-center dark:hover:bg-gray-600 dark:hover:text-white" data-modal-hide="change-assign-modal">
                        <svg class="w-3 h-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 14 14">
                            <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6"/>
                        </svg>
                        <span class="sr-only">Close modal</span>
                    </button>
                </div>
                <!-- Modal body -->
                <div class="p-4 md:p-5">
                    <livewire:partials.tickets.assign_ticket :ticket_id="$ticket->ticket_id"/>
                </div>
            </div>
        </div>
    </div>
</x-layouts.app>