<div>
    <style>
        /* Hide Select all and Deselect all links */
        .fi-ta-select-all {
            display: none !important;
        }

        /* Reduce gap between bulk action buttons */
        .fi-ta-header-toolbar {
            gap: 3px !important;
        }

        /* Make checkboxes more visible with indigo - override Filament defaults */
        input[type="checkbox"],
        input[type="checkbox"].fi-checkbox-input {
            accent-color: #6366f1 !important;
            color: #6366f1 !important;
            width: 20px !important;
            height: 20px !important;
            cursor: pointer !important;
            border-radius: 4px !important;
        }

        /* Thicker border for unchecked checkboxes */
        input[type="checkbox"]:not(:checked),
        input[type="checkbox"].fi-checkbox-input:not(:checked) {
            border: 1.5px solid #d1d5db !important;
        }

        .fi-ta-checkbox {
            opacity: 1 !important;
        }

        .fi-ta-cell-checkbox {
            padding: 0.75rem !important;
        }

        /* Truncate long ticket subjects with ellipsis */
        .fi-ta-text-item-label,
        .fi-ta-text {
            max-width: 400px !important;
            overflow: hidden !important;
            text-overflow: ellipsis !important;
            white-space: nowrap !important;
        }

        /* Make icons white and outlined in bulk action buttons */
        button[class*="bg-indigo"] svg,
        button[class*="bg-indigo"] svg path,
        .bg-indigo-700 svg,
        .bg-indigo-700 svg path,
        [class*="bg-indigo"] svg,
        [class*="bg-indigo"] svg path {
            color: white !important;
            fill: none !important;
            stroke: white !important;
            stroke-width: 2 !important;
        }

        /* Use indigo for table row selection border - override orange */
        .fi-ta-row[aria-selected="true"],
        tr[aria-selected="true"],
        .fi-ta-row-selected,
        [aria-selected="true"],
        .fi-ta-row.fi-selected,
        .fi-ta-row.fi-selected > :first-child::before {
            border-left-color: #6366f1 !important;
            border-inline-start-color: #6366f1 !important;
            background-color: rgba(99, 102, 241, 0.05) !important;
        }

        /* Override any orange/primary colors in table */
        .fi-ta-row.fi-selected > :first-child::before {
            background-color: #6366f1 !important;
        }
    </style>

    {{ $this->table }}

    <!-- Bulk Actions Modal -->
    <flux:modal wire:model="showBulkActionsModal" class="md:w-96">
        <form wire:submit.prevent="assignSelected">
            <flux:heading size="lg">Bulk Actions</flux:heading>

            <flux:subheading class="mb-4">
                <span x-text="$wire.selectedTableRecords.length"></span> ticket(s) selected
            </flux:subheading>

            <div class="space-y-6">
                <flux:field>
                    <flux:label>Assign to Employee</flux:label>
                    <flux:select wire:model="selectedUser">
                        <flux:select.option value="">Leave unchanged</flux:select.option>
                        <flux:select.option value="0">{{ __("None (Unassign)")}}</flux:select.option>
                        @foreach ($employees as $employee)
                            <flux:select.option value="{{ $employee->id }}">{{ $employee->name }}</flux:select.option>
                        @endforeach
                    </flux:select>
                    <flux:description>Assign the selected tickets to an employee</flux:description>
                </flux:field>

                <flux:separator />

                <flux:field>
                    <flux:label>Change Status</flux:label>
                    <flux:select wire:model="selectedStatus">
                        <flux:select.option value="">Leave unchanged</flux:select.option>
                        <flux:select.option value="open">Open</flux:select.option>
                        <flux:select.option value="answered">Answered</flux:select.option>
                        <flux:select.option value="customer-reply">Customer Reply</flux:select.option>
                        <flux:select.option value="closed">Closed</flux:select.option>
                    </flux:select>
                    <flux:description>Change the status of selected tickets</flux:description>
                </flux:field>

                <flux:separator />

                <flux:field>
                    <flux:label>Change Priority</flux:label>
                    <flux:select wire:model="selectedPriority">
                        <flux:select.option value="">Leave unchanged</flux:select.option>
                        <flux:select.option value="low">Low</flux:select.option>
                        <flux:select.option value="medium">Medium</flux:select.option>
                        <flux:select.option value="high">High</flux:select.option>
                        <flux:select.option value="emergency">Emergency</flux:select.option>
                    </flux:select>
                    <flux:description>Change the priority of selected tickets</flux:description>
                </flux:field>
            </div>

            <div class="flex gap-2 mt-6">
                <flux:spacer />
                <flux:button type="button" variant="ghost" wire:click="closeBulkActionsModal">
                    Cancel
                </flux:button>
                <flux:button type="submit" variant="primary" class="!bg-indigo-700 hover:!bg-indigo-500" wire:loading.attr="disabled" wire:target="assignSelected">
                    <span wire:loading.remove wire:target="assignSelected">Update Tickets</span>
                    <span wire:loading wire:target="assignSelected">Updating...</span>
                </flux:button>
            </div>
        </form>
    </flux:modal>

    <!-- Bulk Response Modal -->
    <flux:modal wire:model="showBulkResponseModal" class="md:w-[600px]">
        <form wire:submit.prevent="respondSelected">
            <flux:heading size="lg">Bulk Response</flux:heading>

            <flux:subheading class="mb-4">
                Send a response to <span x-text="$wire.selectedTableRecords.length"></span> ticket(s)
            </flux:subheading>

            <div class="space-y-6">
                <flux:field>
                    <flux:label>Response Message</flux:label>
                    <flux:textarea wire:model="bulkResponseContent" rows="8" placeholder="Type your response here..."></flux:textarea>
                    <flux:description>This response will be added to all selected tickets</flux:description>
                </flux:field>

                <flux:checkbox wire:model="bulkResponseIsNote" label="Mark as internal note (not visible to customers)" />
            </div>

            <div class="flex gap-2 mt-6">
                <flux:spacer />
                <flux:button type="button" variant="ghost" wire:click="closeBulkResponseModal">
                    Cancel
                </flux:button>
                <flux:button type="submit" variant="primary" class="!bg-indigo-700 hover:!bg-indigo-500" wire:loading.attr="disabled" wire:target="respondSelected">
                    <span wire:loading.remove wire:target="respondSelected">Send Response</span>
                    <span wire:loading wire:target="respondSelected">Sending...</span>
                </flux:button>
            </div>
        </form>
    </flux:modal>
</div>