<div wire:poll.visible>
    @if(config('ticaga.design') == 'modern')
        @foreach($responses as $response)
            @if($response->employee_response == '0')
                @if($response->is_note == '2')
                <div class="flex items-start gap-2.5 mt-3">
                        <span class="relative flex h-8 w-8 shrink-0 overflow-hidden rounded-lg">
                            <span class="flex h-full w-full items-center justify-center rounded-lg border-yellow-200 bg-yellow-100 rounded-l-xl rounded-tr-xl dark:border-yellow-200 dark:bg-yellow-100 text-black">
                                SY
                            </span>
                        </span>
                        <div class="flex flex-col w-full max-w-[450px] leading-1.5 p-4 border-yellow-200 bg-yellow-100 rounded-e-xl rounded-es-xl dark:border-yellow-200 dark:bg-yellow-100 rounded-l-xl rounded-tr-xl">
                            <div class="flex items-center space-x-2 rtl:space-x">
                                <span class="text-sm font-semibold text-gray-900 dark:text-black">
                                    System
                                </span>
                                <span class="text-sm font-normal text-gray-900 dark:text-black">
                                    {{ Carbon\Carbon::parse($response->response_created)->format('jS F Y H:i') }}
                                </span>
                            </div>
                            <p class="text-sm font-normal py-2.5 text-gray-900 dark:text-black whitespace-pre-line">
                                {!! Str::of($response->content)->inlinemarkdown(['html_input' => 'strip', 'allow_unsafe_links' => false,]) !!}
                            </p>
                        </div>
                </div>
                @else
                    <div class="flex items-start gap-2.5 mt-3">
                        @if($response->profile_photo_path != '')
                                <img class="w-8 h-8 rounded-full"
                                    src="{{ config('app.url') }}/storage/{{ $response->profile_photo_path }}"
                                    alt="{{ $response->name }}" />
                            
                        @else
                                <img class="w-8 h-8 rounded-full"
                                    src="@php echo "https://gravatar.com/avatar/". hash('sha256', strtolower(trim($response->email))).".png?default=monsterid"; @endphp"
                                    alt="{{ $response->name }}"/>
                        @endif
                        <div class="flex flex-col w-full max-w-[450px] leading-1.5 p-4 border-gray-200 bg-gray-100 rounded-e-xl rounded-es-xl dark:bg-gray-700">
                            <div class="flex items-center space-x-2 rtl:space-x-reverse">
                                    <span class="text-sm font-semibold text-gray-900 dark:text-white">
                                        @if($response->user_id != '0')
                                            <a href="/clients/view/{{ $response->user_id }}">
                                                {{ $response->name }}
                                            </a>
                                        @else
                                            {{ $response->public_name }}
                                        @endif
                                    </span>
                                    <span class="text-sm font-normal text-gray-500 dark:text-gray-400">
                                        {{ Carbon\Carbon::parse($response->response_created)->format('jS F Y H:i') }}
                                    </span>
                                </div>
                                <p class="text-sm font-normal py-2.5 text-gray-900 dark:text-white whitespace-pre-line">
                                    {!! Str::of($response->content)->inlinemarkdown(['html_input' => 'strip', 'allow_unsafe_links' => false,]) !!}
                                </p>

                                {{-- Attachments --}}
                                @if($response->attachments && $response->attachments->count() > 0)
                                <div class="mt-2 pt-2 border-t border-gray-300 dark:border-gray-600">
                                    <div class="flex flex-wrap gap-2">
                                        @foreach($response->attachments as $attachment)
                                            @if($attachment->isImage())
                                                {{-- Image attachment - show inline --}}
                                                <div class="group relative">
                                                    <a href="{{ route('attachments.view', $attachment->id) }}"
                                                       target="_blank"
                                                       class="block rounded-md overflow-hidden border-2 border-gray-300 dark:border-gray-500 hover:border-indigo-500 dark:hover:border-indigo-400 transition-all">
                                                        <img src="{{ $attachment->getThumbnailUrl() ?? route('attachments.view', $attachment->id) }}"
                                                             alt="{{ $attachment->original_filename }}"
                                                             class="max-w-xs max-h-48 object-contain bg-white dark:bg-gray-800"
                                                             loading="lazy">
                                                    </a>
                                                    <div class="mt-1 text-xs text-gray-600 dark:text-gray-300">
                                                        <span>{{ $attachment->original_filename }}</span>
                                                        <span class="text-gray-500 dark:text-gray-400">({{ \App\Services\AttachmentService::formatBytes($attachment->size) }})</span>
                                                    </div>
                                                </div>
                                            @else
                                                {{-- Non-image attachment - show download link --}}
                                                <a href="{{ route('attachments.download', $attachment->id) }}"
                                                   class="inline-flex items-center gap-1.5 px-2.5 py-1.5 text-xs font-medium text-gray-700 dark:text-gray-200 bg-white dark:bg-gray-600 border border-gray-300 dark:border-gray-500 rounded-md hover:bg-gray-50 dark:hover:bg-gray-500 transition-colors">
                                                    <svg class="w-3.5 h-3.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15.172 7l-6.586 6.586a2 2 0 102.828 2.828l6.414-6.586a4 4 0 00-5.656-5.656l-6.415 6.585a6 6 0 108.486 8.486L20.5 13"></path>
                                                    </svg>
                                                    <span>{{ $attachment->original_filename }}</span>
                                                    <span class="text-gray-500 dark:text-gray-400">({{ \App\Services\AttachmentService::formatBytes($attachment->size) }})</span>
                                                </a>
                                            @endif
                                        @endforeach
                                    </div>
                                </div>
                                @endif

                                @hasanyrole('superadmin|employee|admin')
                                <span class="text-sm font-normal text-gray-500 dark:text-gray-400">
                                    {{ $response->ip_address }}@if(!$ticket->organize->isTicket()) - {{ __('Type') }}: {{ $ticket->organize->label() }}@endif
                                </span>
                                @endhasanyrole
                            </div>
                        </div>
                @endif
            @else
                @if($response->is_note == '2')
                <div class="flex items-end gap-2.5 mt-3 flex-row-reverse">
                        <span class="relative flex h-8 w-8 shrink-0 overflow-hidden rounded-lg">
                            <span class="flex h-full w-full items-center justify-center rounded-lg border-yellow-200 bg-yellow-100 rounded-l-xl rounded-tr-xl dark:border-yellow-200 dark:bg-yellow-100 text-black">
                                SY
                            </span>
                        </span>
                        <div class="flex flex-col w-full max-w-[450px] leading-1.5 p-4 border-yellow-200 bg-yellow-100 rounded-l-xl rounded-tr-xl dark:border-yellow-200 dark:bg-yellow-100 rounded-l-xl rounded-tr-xl">
                            <div class="flex items-center space-x-2 rtl:space-x">
                                <span class="text-sm font-semibold text-gray-900 dark:text-black">
                                    System
                                </span>
                                <span class="text-sm font-normal text-gray-900 dark:text-black">
                                    {{ Carbon\Carbon::parse($response->response_created)->format('jS F Y H:i') }}
                                </span>
                            </div>
                            <p class="text-sm font-normal py-2.5 text-gray-900 dark:text-black whitespace-pre-line">
                                {!! Str::of($response->content)->inlinemarkdown(['html_input' => 'strip', 'allow_unsafe_links' => false,]) !!}
                            </p>
                        </div>
                </div>
                @elseif($response->is_note != '1')
                <div class="flex items-end gap-2.5 mt-3 flex-row-reverse">
                    @if($response->profile_photo_path != '')
                        <img class="w-8 h-8 rounded-full"
                            src="{{ config('app.url') }}/storage/{{ $response->profile_photo_path }}"
                            alt="{{ $response->name }}" />
                    @else
                        <img class="w-8 h-8 rounded-full"
                            src="@php echo "https://gravatar.com/avatar/". hash('sha256', strtolower(trim($response->email))).".png?default=monsterid"; @endphp"
                            alt="{{ $response->response_name }}"/>
                    @endif
                        <div class="flex flex-col w-full max-w-[450px] leading-1.5 p-4 border-gray-500 bg-gray-300 rounded-l-xl rounded-tr-xl dark:bg-gray-900 dark:border-gray-700">
                            <div class="flex items-center space-x-2 rtl:space-x">
                                <span class="text-sm font-semibold text-gray-900 dark:text-white">
                                    @if($response->name)
                                        <a href="/clients/view/{{ $response->user_id }}">
                                            {{ $response->response_name }}
                                        </a>
                                    @endif
                                </span>
                                <span class="text-sm font-normal text-gray-500 dark:text-gray-400">
                                    {{ Carbon\Carbon::parse($response->response_created)->format('jS F Y H:i') }}
                                </span>
                            </div>
                            <p class="text-sm font-normal py-2.5 text-gray-900 dark:text-white whitespace-pre-line">
                                {!! Str::of($response->content)->inlinemarkdown(['html_input' => 'strip', 'allow_unsafe_links' => false,]) !!}
                            </p>

                            {{-- Attachments --}}
                            @if($response->attachments && $response->attachments->count() > 0)
                            <div class="mt-2 pt-2 border-t border-gray-400 dark:border-gray-600">
                                <div class="flex flex-wrap gap-2">
                                    @foreach($response->attachments as $attachment)
                                        @if($attachment->isImage())
                                            {{-- Image attachment - show inline --}}
                                            <div class="group relative">
                                                <a href="{{ route('attachments.view', $attachment->id) }}"
                                                   target="_blank"
                                                   class="block rounded-md overflow-hidden border-2 border-gray-400 dark:border-gray-600 hover:border-indigo-500 dark:hover:border-indigo-400 transition-all">
                                                    <img src="{{ $attachment->getThumbnailUrl() ?? route('attachments.view', $attachment->id) }}"
                                                         alt="{{ $attachment->original_filename }}"
                                                         class="max-w-xs max-h-48 object-contain bg-white dark:bg-gray-800"
                                                         loading="lazy">
                                                </a>
                                                <div class="mt-1 text-xs text-gray-600 dark:text-gray-300">
                                                    <span>{{ $attachment->original_filename }}</span>
                                                    <span class="text-gray-500 dark:text-gray-400">({{ \App\Services\AttachmentService::formatBytes($attachment->size) }})</span>
                                                </div>
                                            </div>
                                        @else
                                            {{-- Non-image attachment - show download link --}}
                                            <a href="{{ route('attachments.download', $attachment->id) }}"
                                               class="inline-flex items-center gap-1.5 px-2.5 py-1.5 text-xs font-medium text-gray-700 dark:text-gray-200 bg-gray-50 dark:bg-gray-800 border border-gray-400 dark:border-gray-600 rounded-md hover:bg-gray-100 dark:hover:bg-gray-700 transition-colors">
                                                <svg class="w-3.5 h-3.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15.172 7l-6.586 6.586a2 2 0 102.828 2.828l6.414-6.586a4 4 0 00-5.656-5.656l-6.415 6.585a6 6 0 108.486 8.486L20.5 13"></path>
                                                </svg>
                                                <span>{{ $attachment->original_filename }}</span>
                                                <span class="text-gray-500 dark:text-gray-400">({{ \App\Services\AttachmentService::formatBytes($attachment->size) }})</span>
                                            </a>
                                        @endif
                                    @endforeach
                                </div>
                            </div>
                            @endif

                            @hasanyrole('superadmin|employee|admin')
                            <span class="text-sm font-normal text-gray-500 dark:text-gray-400">
                                {{ $response->ip_address }}
                            </span>
                            @endhasanyrole
                        </div>
                </div>
                @elseif($response->is_note == '1' && !Auth::guest() && Auth::user()->hasAnyRole('superadmin', 'admin', 'employee'))
                    <div class="flex items-end gap-2.5 mt-3 flex-row-reverse">
                        @if($response->profile_photo_path != '')
                            <img class="w-8 h-8 rounded-full"
                                src="{{ config('app.url') }}/storage/{{ $response->profile_photo_path }}"
                                alt="{{ $response->name }}" />
                        @else
                            <img class="w-8 h-8 rounded-full"
                                src="@php echo "https://gravatar.com/avatar/". hash('sha256', strtolower(trim($response->email))).".png?default=monsterid"; @endphp"
                                alt="{{ $response->name }}"/>
                        @endif
                            <div class="flex flex-col w-full max-w-[450px] leading-1.5 p-4 border-yellow-200 bg-yellow-100 rounded-l-xl rounded-tr-xl dark:border-yellow-200 dark:bg-yellow-100">
                                <div class="flex items-center space-x-2 rtl:space-x">
                                    <span class="text-sm font-semibold text-gray-900 dark:text-black">
                                        @if($response->name)
                                            <a href="/clients/view/{{ $response->user_id }}">
                                                {{ $response->name }}
                                            </a>
                                        @endif
                                    </span>
                                    <span class="text-sm font-normal text-gray-500 dark:text-black">
                                        {{ Carbon\Carbon::parse($response->response_created)->format('jS F Y H:i') }}
                                    </span>
                                </div>
                                <p class="text-sm font-normal py-2.5 text-gray-900 dark:text-black whitespace-pre-line">
                                    {!! Str::of($response->content)->inlinemarkdown(['html_input' => 'strip', 'allow_unsafe_links' => false,]) !!}
                                </p>

                                {{-- Attachments --}}
                                @if($response->attachments && $response->attachments->count() > 0)
                                <div class="mt-2 pt-2 border-t border-yellow-300 dark:border-yellow-300">
                                    <div class="flex flex-wrap gap-2">
                                        @foreach($response->attachments as $attachment)
                                            @if($attachment->isImage())
                                                {{-- Image attachment - show inline --}}
                                                <div class="group relative">
                                                    <a href="{{ route('attachments.view', $attachment->id) }}"
                                                       target="_blank"
                                                       class="block rounded-md overflow-hidden border-2 border-yellow-300 dark:border-yellow-300 hover:border-yellow-500 dark:hover:border-yellow-500 transition-all">
                                                        <img src="{{ $attachment->getThumbnailUrl() ?? route('attachments.view', $attachment->id) }}"
                                                             alt="{{ $attachment->original_filename }}"
                                                             class="max-w-xs max-h-48 object-contain bg-yellow-50 dark:bg-yellow-50"
                                                             loading="lazy">
                                                    </a>
                                                    <div class="mt-1 text-xs text-gray-900 dark:text-gray-900">
                                                        <span>{{ $attachment->original_filename }}</span>
                                                        <span class="text-gray-600 dark:text-gray-600">({{ \App\Services\AttachmentService::formatBytes($attachment->size) }})</span>
                                                    </div>
                                                </div>
                                            @else
                                                {{-- Non-image attachment - show download link --}}
                                                <a href="{{ route('attachments.download', $attachment->id) }}"
                                                   class="inline-flex items-center gap-1.5 px-2.5 py-1.5 text-xs font-medium text-gray-900 dark:text-gray-900 bg-yellow-50 dark:bg-yellow-50 border border-yellow-300 dark:border-yellow-300 rounded-md hover:bg-white dark:hover:bg-white transition-colors">
                                                    <svg class="w-3.5 h-3.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15.172 7l-6.586 6.586a2 2 0 102.828 2.828l6.414-6.586a4 4 0 00-5.656-5.656l-6.415 6.585a6 6 0 108.486 8.486L20.5 13"></path>
                                                    </svg>
                                                    <span>{{ $attachment->original_filename }}</span>
                                                    <span class="text-gray-600 dark:text-gray-600">({{ \App\Services\AttachmentService::formatBytes($attachment->size) }})</span>
                                                </a>
                                            @endif
                                        @endforeach
                                    </div>
                                </div>
                                @endif

                                @hasanyrole('superadmin|employee|admin')
                                <span class="text-sm font-normal text-gray-500 dark:text-black">
                                    {{ $response->ip_address }}
                                </span>
                                @endhasanyrole
                            </div>
                    </div>
                @endif

            @endif
        @endforeach
    @else
        @foreach($responses as $response)
       
        <div class="mt-3 max-w-7xl mx-auto overflow-x-auto @if($response->employee_response == '1' && $response->is_note == '0') border-gray-200 dark:border-gray-600 bg-gray-100 dark:bg-gray-700 dark:text-white @elseif($response->employee_response == '1' && $response->is_note == '1') border-yellow-200 bg-yellow-100 dark:border-yellow-200 dark:bg-yellow-100 text-black dark:text-yellow-800 @else bg-white border-neutral-200 dark:text-white dark:bg-gray-900 dark:border-neutral-700 @endif border rounded-lg shadow-sm p-1">
            <div class="border-b-1 @if($response->employee_response == '1' && $response->is_note == '1') border-yellow-200 dark:border-yellow-200 @else border-neutral-200 dark:border-neutral-700 @endif grid grid-cols-1 md:grid-cols-4 gap-4 px-3">
                <div class="mb-2 mt-1 flex items-center">
                    <div class="flex items-center gap-2 sm:gap-4">
                        @php
                            $customer = \App\Models\User::find($response->user_id);
                            if($customer)
                            {
                                $customer_role = $customer->roles->pluck('name')[0];
                            } else {
                                $customer_role = '';
                            }

                            if($customer_role)
                            {
                                if($customer_role == 'superadmin') {
                                    $role = "Senior Management";
                                } elseif($customer_role == 'admin') {
                                    $role = "Management";
                                } elseif($customer_role == 'employee') {
                                    $role = "Employee";
                                } elseif($customer_role == 'customer') {
                                    $role = "Customer";
                                } else {
                                    $role = "Guest";
                                }
                            } else {
                                $role = "Guest";
                            }
                            if(!Auth::guest() && !empty($customer->profile_photo_path))
                            {
                                $avatar = asset('storage/' . $customer->profile_photo_path);
                            } else {
                                $avatar = "https://gravatar.com/avatar/". hash('sha256', strtolower(trim($customer->email ?? $ticket->public_email))).".png?default=monsterid";
                            }
                        @endphp
                        <flux:avatar size="lg" class="max-sm:size-8" src="{{ $avatar }}" />
                        <div class="flex flex-col">
                            @if($response->employee_response == '1' && $response->is_note == '1')
                                <flux:heading class="dark:text-yellow-800">
                                    @if($ticket->user_id != '0')
                                        <a href="{{ route('view_client',[$response->user_id] ) }}">
                                            {{  $customer->name ?? 'System' }}
                                        </a>
                                    @else
                                        {{ $ticket->public_name }}
                                    @endif
                                    @if(!Auth::guest() && $response->user_id == Auth::user()->id)
                                        <x-mary-badge value="You" class="badge-info badge-sm rounded-sm" />
                                    @endif
                                    @if($response->employee_response == '1' && $response->is_note == '1')
                                        <x-mary-badge value="Private Note" class="badge-warning badge-sm rounded-sm" />
                                    @endif
                                </flux:heading>
                            @else
                                <flux:heading>
                                    @if($response->user_id != '0')
                                        <a href="{{ route('view_client',[$response->user_id] ) }}">
                                            {{  $customer->name ?? 'System' }}
                                        </a>
                                    @else
                                        @if($response->employee_response == '1')
                                            {{ $response->name }}
                                        @else
                                            {{ $ticket->public_name }}
                                        @endif
                                    @endif
                                    @if(!Auth::guest() && $response->user_id == Auth::user()->id)
                                        <x-mary-badge value="You" class="badge-info badge-sm rounded-sm" />
                                    @endif
                                    @if($response->employee_response == '1' && $response->is_note == '1')
                                        <x-mary-badge value="Private Note" class="badge-warning badge-sm badge-soft rounded-sm" />
                                    @endif
                                </flux:heading>
                            @endif
                            @if($response->employee_response == '1' && $response->is_note == '1')
                                <flux:text class="text-yellow-800">Note</flux:text>
                            @else
                                <flux:text>{{ $role }} @if(!$response->organize->isTicket())<small>via {{ $response->organize->label() }}</small>@endif</flux:text>
                            @endif
                        </div>
                    </div>
                </div>
                <div class="col-span-3 text-left sm:text-right sm:my-auto text-gray-900 @if($response->employee_response == '1' && $response->is_note == '1') dark:text-yellow-800 @else dark:text-white @endif">
                    <flux:text class="mb-2">{{ Carbon\Carbon::parse($response->response_created)->format('jS F Y H:i') }}</flux:text>
                </div>
            </div>
            <div class="px-3">
                <p class="text-sm font-normal text-gray-900 @if($response->employee_response == '1' && $response->is_note == '1') dark:text-yellow-800 @else dark:text-white @endif whitespace-pre-line">
                    {!! Str::of($response->content)->inlinemarkdown(['html_input' => 'strip', 'allow_unsafe_links' => false,]) !!}
                </p>

                {{-- Attachments --}}
                @if($response->attachments && $response->attachments->count() > 0)
                <div class="mt-3 pt-3 border-t @if($response->employee_response == '1' && $response->is_note == '1') border-yellow-300 dark:border-yellow-300 @else border-gray-200 dark:border-gray-700 @endif">
                    <div class="flex flex-wrap gap-2">
                        @foreach($response->attachments as $attachment)
                            @if($attachment->isImage())
                                {{-- Image attachment - show inline --}}
                                <div class="group relative">
                                    <a href="{{ route('attachments.view', $attachment->id) }}"
                                       target="_blank"
                                       class="block rounded-md overflow-hidden border-2 @if($response->employee_response == '1' && $response->is_note == '1') border-yellow-300 dark:border-yellow-300 hover:border-yellow-500 dark:hover:border-yellow-500 @else border-gray-300 dark:border-gray-600 hover:border-indigo-500 dark:hover:border-indigo-400 @endif transition-all">
                                        <img src="{{ $attachment->getThumbnailUrl() ?? route('attachments.view', $attachment->id) }}"
                                             alt="{{ $attachment->original_filename }}"
                                             class="max-w-xs max-h-48 object-contain @if($response->employee_response == '1' && $response->is_note == '1') bg-yellow-50 dark:bg-yellow-50 @else bg-white dark:bg-gray-800 @endif"
                                             loading="lazy">
                                    </a>
                                    <div class="mt-1 text-xs @if($response->employee_response == '1' && $response->is_note == '1') text-gray-900 dark:text-gray-900 @else text-gray-600 dark:text-gray-300 @endif">
                                        <span>{{ $attachment->original_filename }}</span>
                                        <span class="@if($response->employee_response == '1' && $response->is_note == '1') text-gray-600 dark:text-gray-600 @else text-gray-500 dark:text-gray-400 @endif">({{ \App\Services\AttachmentService::formatBytes($attachment->size) }})</span>
                                    </div>
                                </div>
                            @else
                                {{-- Non-image attachment - show download link --}}
                                <a href="{{ route('attachments.download', $attachment->id) }}"
                                   class="inline-flex items-center gap-1.5 px-2.5 py-1.5 text-xs font-medium @if($response->employee_response == '1' && $response->is_note == '1') text-gray-900 dark:text-gray-900 bg-yellow-50 dark:bg-yellow-50 border-yellow-300 dark:border-yellow-300 hover:bg-white dark:hover:bg-white @else text-gray-700 dark:text-gray-200 bg-gray-50 dark:bg-gray-800 border-gray-300 dark:border-gray-600 hover:bg-gray-100 dark:hover:bg-gray-700 @endif border rounded-md transition-colors">
                                    <svg class="w-3.5 h-3.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15.172 7l-6.586 6.586a2 2 0 102.828 2.828l6.414-6.586a4 4 0 00-5.656-5.656l-6.415 6.585a6 6 0 108.486 8.486L20.5 13"></path>
                                    </svg>
                                    <span>{{ $attachment->original_filename }}</span>
                                    <span class="@if($response->employee_response == '1' && $response->is_note == '1') text-gray-600 dark:text-gray-600 @else text-gray-500 dark:text-gray-400 @endif">({{ \App\Services\AttachmentService::formatBytes($attachment->size) }})</span>
                                </a>
                            @endif
                        @endforeach
                    </div>
                </div>
                @endif
            </div>
        </div>
        @endforeach
    @endif
</div>