<div class="flex items-center gap-1"
     x-data="{ hoveredRating: 0, currentRating: @entangle('rating') }"
     wire:key="rating-{{ $ticket_id }}">
    @for ($i = 1; $i <= 5; $i++)
        <button
            type="button"
            wire:click="setRating({{ $i }})"
            @mouseenter="hoveredRating = {{ $i }}"
            @mouseleave="hoveredRating = 0"
            @if(!$canRate) disabled @endif
            class="{{ !$canRate ? 'cursor-not-allowed opacity-50' : 'cursor-pointer' }}"
        >
            <x-mary-icon
                name="lucide.star"
                class="w-6 h-6"
                x-bind:class="(hoveredRating >= {{ $i }} || (hoveredRating === 0 && currentRating >= {{ $i }})) ? 'fill-yellow-400 text-yellow-400' : 'text-gray-300 dark:text-gray-600'"
            />
        </button>
    @endfor
</div>
