<div class="w-full min-h-screen pb-20 md:pb-8 overflow-x-hidden">
    <style>
        /* Fix file input button border radius and styling */
        #ticket-files::file-selector-button {
            border-top-left-radius: 0.5rem;
            border-bottom-left-radius: 0.5rem;
        }

        /* For Safari support */
        #ticket-files::-webkit-file-upload-button {
            border-top-left-radius: 0.5rem;
            border-bottom-left-radius: 0.5rem;
        }

        /* Firefox-specific styling - match Tailwind file: classes */
        #ticket-files::-moz-file-upload-button {
            margin-right: 1rem; /* file:mr-4 */
            padding: 0.625rem 1rem; /* file:py-2.5 file:px-4 */
            border: 0; /* file:border-0 */
            font-size: 0.875rem; /* file:text-sm */
            line-height: 1.25rem;
            font-weight: 600; /* file:font-semibold */
            background-color: #1f2937; /* file:bg-gray-800 */
            color: white; /* file:text-white */
            cursor: pointer; /* file:cursor-pointer */
            border-radius: 0.5rem; /* file:rounded-lg */
            transition-property: background-color;
            transition-timing-function: cubic-bezier(0.4, 0, 0.2, 1);
            transition-duration: 200ms;
        }

        #ticket-files::-moz-file-upload-button:hover {
            background-color: #374151; /* hover:file:bg-gray-700 */
        }

        /* Dark mode for Firefox */
        .dark #ticket-files::-moz-file-upload-button {
            background-color: #374151; /* dark:file:bg-gray-700 */
        }

        .dark #ticket-files::-moz-file-upload-button:hover {
            background-color: #4b5563; /* dark:hover:file:bg-gray-600 */
        }

        /* Firefox file input padding fix - match Safari rendering */
        @-moz-document url-prefix() {
            #ticket-files {
                padding: 0.625rem 1rem !important;
            }
        }
    </style>

    <flux:heading size="xl" level="1" class="font-bold text-gray-900 dark:text-white">
        {{ __("Create a ") }} {{  ucwords($department->department_name) }} {{ _("ticket") }}
    </flux:heading>
    <flux:text size="sm" class="text-gray-600 dark:text-gray-400">
        <livewire:departments.eta :department_id="$department->id"/>
    </flux:text>
    <flux:separator variant="subtle" class="mt-3" />
    <form wire:submit="save" class="space-y-4 sm:space-y-6 mt-2 max-w-full">
            @if(Auth::guest())
                <div class="mt-3 p-4 mb-4 text-sm text-red-800 bg-red-50 border border-red-300 rounded-lg dark:shadow-sm dark:bg-gray-900 dark:text-white dark:border-neutral-700" role="alert">
                {{ __("Please be aware as you're not logged in, this ticket won't be stored on your account.") }}
                </div>

                <div class="mt-4 grid grid-cols-1 gap-x-4 gap-y-6 sm:grid-cols-2">
                    <div>
                        <div class="mt-2">
                            <flux:input label="{{ __('Full Name') }}" wire:model.live="public_name" />
                        </div>
                    </div>

                    <div>
                        <div class="mt-2">
                            <flux:input label="{{ __('Email Address') }}" wire:model.live="public_email" />
                        </div>
                    </div>
                </div>
            @endif

            @hasanyrole('superadmin|employee|admin')
                @if($users)
                <div class="col-span-full mt-3">
                    <div class="mt-2 grid grid-cols-1">
                        <flux:select label="Customer" badge="optional" wire:model="customer_id">
                            <flux:select.option>{{  __('Select Customer Account') }}</flux:select.option>
                            @foreach ($users as $user)
                                <flux:select.option wire:key="{{ $user->id }}" value="{{ $user->id }}">{{ $user->name }}</flux:select.option>
                            @endforeach
                        </flux:select>
                    </div>
                </div>
                @endif
            @endhasanyrole

            <div class="col-span-full">
                <div class="mt-2">
                    <flux:input label="{{ __('Subject') }}" wire:model.live="subject" />
                </div>
            </div>

            <div class="grid grid-cols-1 gap-x-4 gap-y-6 @if($department_info->allows_high_priority != '3' && $department_info->cc_enabled == '1')sm:grid-cols-2 @endif">
                @if($department_info->cc_enabled == '1')
                    <div>
                        <div class="mt-2">
                            <flux:input label="{{ __('CC') }}" badge="optional" wire:model.live="cc" />
                        </div>
                    </div>
                @endif
                @if($department_info->allows_high_priority != '3')
                    <div>
                        <div class="mt-2 relative">
                            <label for="priority-dropdown" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">{{ __('Priority') }}</label>
                            <button id="priority-dropdown-button" data-dropdown-toggle="priority-dropdown" data-dropdown-placement="bottom" class="text-gray-900 bg-white border border-gray-300 focus:outline-none hover:bg-gray-100 focus:ring-4 focus:ring-gray-100 font-medium rounded-lg text-sm px-5 py-2.5 text-center inline-flex items-center dark:bg-gray-900 dark:text-white dark:border-gray-600 dark:hover:bg-gray-700 dark:hover:border-gray-600 dark:focus:ring-gray-700 w-full justify-between" type="button">
                                <span id="selected-priority-text">
                                    @php
                                        $selectedPriority = collect(App\Enums\Priorities::cases())->firstWhere('value', $priority);
                                    @endphp
                                    {{ $selectedPriority ? $selectedPriority->label() : __('Select a priority') }}
                                </span>
                                <svg class="w-2.5 h-2.5 ms-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 10 6">
                                    <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 1 4 4 4-4"/>
                                </svg>
                            </button>
                            <!-- Dropdown menu -->
                            <div id="priority-dropdown" class="z-50 hidden bg-white divide-y divide-gray-100 rounded-lg shadow-lg dark:bg-gray-700 w-full">
                                <ul class="py-2 text-sm" aria-labelledby="priority-dropdown-button">
                                    @if(!Auth::guest() && Auth::user()->hasAnyRole('superadmin','employee','admin'))
                                        @foreach (App\Enums\Priorities::cases() as $case)
                                            <li>
                                                <a href="#" wire:click.prevent="$set('priority', '{{ $case->value }}')" onclick="document.getElementById('selected-priority-text').innerText='{{ $case->label() }}'; document.getElementById('priority-dropdown').classList.add('hidden');" class="block px-4 py-2 hover:bg-gray-100 dark:hover:bg-gray-600 dark:hover:text-white">
                                                    <div class="font-medium">{{ $case->label() }}</div>
                                                    @if(config('ticaga.priority_type') != 'dropdown')
                                                        <div class="text-xs text-gray-500 dark:text-gray-400">{{ $case->description() }}</div>
                                                    @endif
                                                </a>
                                            </li>
                                        @endforeach
                                    @else
                                        @if($department_info->allows_high_priority == '1')
                                            @foreach (App\Enums\Priorities::cases() as $case)
                                                @if($case->value != 'none')
                                                    <li>
                                                        <a href="#" wire:click.prevent="$set('priority', '{{ $case->value }}')" onclick="document.getElementById('selected-priority-text').innerText='{{ $case->label() }}'; document.getElementById('priority-dropdown').classList.add('hidden');" class="block px-4 py-2 hover:bg-gray-100 dark:hover:bg-gray-600 dark:hover:text-white">
                                                            <div class="font-medium">{{ $case->label() }}</div>
                                                            @if(config('ticaga.priority_type') != 'dropdown')
                                                                <div class="text-xs text-gray-500 dark:text-gray-400">{{ $case->description() }}</div>
                                                            @endif
                                                        </a>
                                                    </li>
                                                @endif
                                            @endforeach
                                        @else
                                            @foreach (App\Enums\Priorities::cases() as $case)
                                                @if(!$case->priority())
                                                    @if($case->value != 'none')
                                                        <li>
                                                            <a href="#" wire:click.prevent="$set('priority', '{{ $case->value }}')" onclick="document.getElementById('selected-priority-text').innerText='{{ $case->label() }}'; document.getElementById('priority-dropdown').classList.add('hidden');" class="block px-4 py-2 hover:bg-gray-100 dark:hover:bg-gray-600 dark:hover:text-white">
                                                                <div class="font-medium">{{ $case->label() }}</div>
                                                                @if(config('ticaga.priority_type') != 'dropdown')
                                                                    <div class="text-xs text-gray-500 dark:text-gray-400">{{ $case->description() }}</div>
                                                                @endif
                                                            </a>
                                                        </li>
                                                    @endif
                                                @endif
                                            @endforeach
                                        @endif
                                    @endif
                                </ul>
                            </div>
                        </div>
                    </div>
                @endif
            </div>

            <div class="col-span-full">
                <div class="mt-2">
                    <flux:textarea label="Message" rows="4" resize="vertical" wire:model="content" placeholder="The more information you provide, the better we can assist you."/>
                </div>
            </div>

            {{-- File Attachments --}}
            @if($settings['enabled'] ?? false)
            <div class="col-span-full">
                <label for="ticket-files" class="flex items-center gap-2 text-sm font-semibold text-gray-900 dark:text-white mb-2">
                    <svg class="w-4 h-4 text-indigo-600 dark:text-indigo-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15.172 7l-6.586 6.586a2 2 0 102.828 2.828l6.414-6.586a4 4 0 00-5.656-5.656l-6.415 6.585a6 6 0 108.486 8.486L20.5 13"></path>
                    </svg>
                    {{ __('Attachments') }}
                </label>
                <div class="ml-4">
                    <input
                        type="file"
                        id="ticket-files"
                        wire:model="files"
                        multiple
                        accept="{{ $this->getAcceptedFileTypes() }}"
                        class="block w-full text-sm text-gray-900 dark:text-gray-300 border border-gray-300 dark:border-gray-600 rounded-lg cursor-pointer bg-gray-50 dark:bg-gray-800 focus:outline-none focus:ring-2 focus:ring-indigo-600 dark:focus:ring-indigo-500 file:mr-4 file:py-2.5 file:px-4 file:border-0 file:text-sm file:font-semibold file:bg-gray-800 dark:file:bg-gray-700 file:text-white dark:file:text-white hover:file:bg-gray-700 dark:hover:file:bg-gray-600 file:cursor-pointer file:rounded-lg transition-all duration-200"
                    />

                    {{-- Upload Progress Bar --}}
                    <div x-data="{ uploadProgress: 0 }"
                         x-on:livewire-upload-start="uploadProgress = 0"
                         x-on:livewire-upload-finish="uploadProgress = 100"
                         x-on:livewire-upload-error="uploadProgress = 0"
                         x-on:livewire-upload-progress="uploadProgress = $event.detail.progress"
                         x-show="uploadProgress > 0 && uploadProgress < 100"
                         x-cloak
                         class="mt-2">
                        <div class="flex items-center gap-3">
                            <div class="flex-1 bg-gray-200 dark:bg-gray-700 rounded-full h-2.5 overflow-hidden">
                                <div class="bg-indigo-600 dark:bg-indigo-500 h-2.5 rounded-full transition-all duration-300 ease-out"
                                     :style="`width: ${uploadProgress}%`"></div>
                            </div>
                            <span class="text-sm font-medium text-gray-700 dark:text-gray-300 min-w-[3rem] text-right"
                                  x-text="`${Math.round(uploadProgress)}%`"></span>
                        </div>
                        <p class="mt-1 text-xs text-gray-600 dark:text-gray-400">Uploading files, please wait...</p>
                    </div>

                    @error('files.*')
                        <p class="mt-1.5 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                    @enderror
                </div>

                {{-- Upload Info Box --}}
                <div class="mt-3 p-3 bg-gray-50 dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700">
                    @if(Auth::check() && Auth::user()->hasAnyRole('superadmin', 'admin', 'employee'))
                        {{-- Employee View - No limits --}}
                        <div class="grid grid-cols-1 sm:grid-cols-2 gap-2 sm:gap-3 text-xs">
                            <div class="flex items-center gap-2">
                                <svg class="w-4 h-4 text-gray-400 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                                </svg>
                                <div>
                                    <span class="text-gray-500 dark:text-gray-400">Max size:</span>
                                    <span class="font-semibold text-gray-900 dark:text-white ml-1">{{ $settings['max_file_size_mb'] }}MB</span>
                                </div>
                            </div>
                            <div class="flex items-center gap-2">
                                <svg class="w-4 h-4 text-green-500 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                                </svg>
                                <div>
                                    <span class="text-gray-500 dark:text-gray-400">Selected:</span>
                                    <span class="font-semibold text-gray-900 dark:text-white ml-1">{{ count($files ?? []) }}</span>
                                    <span class="text-green-600 dark:text-green-400 text-xs ml-1">(unlimited)</span>
                                </div>
                            </div>
                        </div>
                    @else
                        {{-- Customer View - With limits --}}
                        <div class="grid grid-cols-1 sm:grid-cols-3 gap-2 sm:gap-3 text-xs">
                            <div class="flex items-center gap-2">
                                <svg class="w-4 h-4 text-gray-400 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                                </svg>
                                <div>
                                    <span class="text-gray-500 dark:text-gray-400">Max size:</span>
                                    <span class="font-semibold text-gray-900 dark:text-white ml-1">{{ $settings['max_file_size_mb'] }}MB</span>
                                </div>
                            </div>
                            <div class="flex items-center gap-2">
                                <svg class="w-4 h-4 text-gray-400 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                                </svg>
                                <div>
                                    <span class="text-gray-500 dark:text-gray-400">Max files:</span>
                                    <span class="font-semibold text-gray-900 dark:text-white ml-1">{{ $settings['max_files_per_ticket'] }}</span>
                                </div>
                            </div>
                            <div class="flex items-center gap-2">
                                <svg class="w-4 h-4 text-gray-400 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                                </svg>
                                <div>
                                    <span class="text-gray-500 dark:text-gray-400">Selected:</span>
                                    <span class="font-semibold text-gray-900 dark:text-white ml-1">{{ count($files ?? []) }}</span>
                                </div>
                            </div>
                        </div>
                    @endif

                    {{-- Selected Files Indicator --}}
                    @if(!empty($files))
                        <div class="mt-3 pt-3 border-t border-gray-200 dark:border-gray-700">
                            <div class="flex items-center gap-2 text-indigo-600 dark:text-indigo-400">
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                                </svg>
                                <span class="text-xs font-semibold">{{ count($files) }} file{{ count($files) > 1 ? 's' : '' }} selected and ready to upload</span>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
            @endif

            <p class="text-sm leading-6 text-gray-600 dark:text-white">
                {{ __('Your IP Address: ') }}{{ $ip_address }} {{ __(' is recorded on submission.') }}</p>
            <flux:button class="!bg-indigo-700 hover:!bg-indigo-500 !text-white" type="submit" wire:loading.attr="disabled" wire:target="files">
                <span wire:loading.remove wire:target="save,files">{{ __('Create') }}</span>
                <span wire:loading wire:target="files">{{ __('Uploading files...') }}</span>
                <span wire:loading wire:target="save">{{ __('Creating ticket...') }}</span>
            </flux:button>
    </form>
</div>