<div>
    <style>
        /* Fix file input button border radius and styling */
        #response-files::file-selector-button {
            border-top-left-radius: 0.5rem;
            border-bottom-left-radius: 0.5rem;
        }

        /* For Safari support */
        #response-files::-webkit-file-upload-button {
            border-top-left-radius: 0.5rem;
            border-bottom-left-radius: 0.5rem;
        }

        /* Firefox-specific styling - match Tailwind file: classes */
        #response-files::-moz-file-upload-button {
            margin-right: 1rem; /* file:mr-4 */
            padding: 0.625rem 1rem; /* file:py-2.5 file:px-4 */
            border: 0; /* file:border-0 */
            font-size: 0.875rem; /* file:text-sm */
            line-height: 1.25rem;
            font-weight: 600; /* file:font-semibold */
            background-color: #1f2937; /* file:bg-gray-800 */
            color: white; /* file:text-white */
            cursor: pointer; /* file:cursor-pointer */
            border-radius: 0.5rem; /* file:rounded-lg */
            transition-property: background-color;
            transition-timing-function: cubic-bezier(0.4, 0, 0.2, 1);
            transition-duration: 200ms;
        }

        #response-files::-moz-file-upload-button:hover {
            background-color: #374151; /* hover:file:bg-gray-700 */
        }

        /* Dark mode for Firefox */
        .dark #response-files::-moz-file-upload-button {
            background-color: #374151; /* dark:file:bg-gray-700 */
        }

        .dark #response-files::-moz-file-upload-button:hover {
            background-color: #4b5563; /* dark:hover:file:bg-gray-600 */
        }

        /* Firefox file input height fix - match Safari rendering */
        @-moz-document url-prefix() {
            #response-files {
                padding: 0.5rem 0.75rem 0.5rem 20px !important;
                height: auto !important;
                margin-left: -1rem !important;
                width: calc(100% + 1rem) !important;
            }

            #response-files::-moz-file-upload-button {
                margin: 0 0.75rem 0 0 !important;
                padding-left: 1rem !important;
                border-top-left-radius: 0.5rem !important;
                border-bottom-left-radius: 0.5rem !important;
            }
        }
    </style>

    <form wire:submit.prevent="send">
        <div class="space-y-5">
            {{-- Response Type Selection (Employees Only) --}}
            @if(Auth::check() and Auth::user()->hasAnyRole('superadmin', 'admin', 'employee'))
            <div>
                <label for="response_type" class="flex items-center gap-2 text-sm font-semibold text-gray-900 dark:text-white mb-2">
                    <svg class="w-4 h-4 text-indigo-600 dark:text-indigo-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z"></path>
                    </svg>
                    {{ __('Type') }}
                </label>
                <select id="response_type" name="response_type" class="col-start-1 row-start-1 w-full appearance-none rounded-lg bg-white py-2.5 pr-10 pl-3.5 text-base text-gray-900 dark:text-white dark:bg-gray-800 outline outline-1 -outline-offset-1 outline-gray-300 dark:outline-gray-600 focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 dark:focus:outline-indigo-500 transition-all duration-200 sm:text-sm" wire:model.live="response_type">
                    <option value="0" class="dark:text-white">{{ __('Response') }}</option>
                    <option value="1" class="dark:text-white">{{ __('Private Note') }}</option>
                </select>
                @error('response_type')
                    <p class="mt-1.5 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                @enderror
            </div>
            @endif

            {{-- Response Content --}}
            <div>
                <label for="content" class="flex items-center gap-2 text-sm font-semibold text-gray-900 dark:text-white mb-2">
                    <svg class="w-4 h-4 text-indigo-600 dark:text-indigo-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 10h.01M12 10h.01M16 10h.01M9 16H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-5l-5 5v-5z"></path>
                    </svg>
                    {{ __('Response') }}
                </label>
                <textarea
                    name="content"
                    id="content"
                    rows="6"
                    class="block w-full rounded-lg px-3.5 py-3 text-base text-gray-900 dark:text-white dark:bg-gray-800 outline outline-1 -outline-offset-1 outline-gray-300 dark:outline-gray-600 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 dark:focus:outline-indigo-500 transition-all duration-200 sm:text-sm resize-y"
                    style="line-height: 1.5;"
                    placeholder="{{ __('Type your response here...') }}"
                    wire:model.live="content"
                ></textarea>
                @error('content')
                    <p class="mt-1.5 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                @enderror

                {{-- Character count helper --}}
                <div class="mt-1.5 text-xs text-gray-500 dark:text-gray-400 flex justify-between items-center">
                    <span>{{ __('Markdown formatting is supported') }}</span>
                    @if(strlen($content) > 0)
                        <span>{{ strlen($content) }} {{ __('characters') }}</span>
                    @endif
                </div>
            </div>

            {{-- File Attachments --}}
            @if($settings['enabled'] ?? false)
            <div>
                <label for="response-files" class="flex items-center gap-2 text-sm font-semibold text-gray-900 dark:text-white mb-2">
                    <svg class="w-4 h-4 text-indigo-600 dark:text-indigo-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15.172 7l-6.586 6.586a2 2 0 102.828 2.828l6.414-6.586a4 4 0 00-5.656-5.656l-6.415 6.585a6 6 0 108.486 8.486L20.5 13"></path>
                    </svg>
                    {{ __('Attachments') }}
                </label>
                <div class="ml-4">
                    <input
                        type="file"
                        id="response-files"
                        wire:model="files"
                        multiple
                        accept="{{ $this->getAcceptedFileTypes() }}"
                        class="block w-full text-sm text-gray-900 dark:text-gray-300 border border-gray-300 dark:border-gray-600 rounded-lg cursor-pointer bg-gray-50 dark:bg-gray-800 focus:outline-none focus:ring-2 focus:ring-indigo-600 dark:focus:ring-indigo-500 file:mr-4 file:py-2.5 file:px-4 file:border-0 file:text-sm file:font-semibold file:bg-gray-800 dark:file:bg-gray-700 file:text-white dark:file:text-white hover:file:bg-gray-700 dark:hover:file:bg-gray-600 file:cursor-pointer file:rounded-lg transition-all duration-200"
                    />

                    {{-- Upload Progress Bar --}}
                    <div x-data="{ uploadProgress: 0 }"
                         x-on:livewire-upload-start="uploadProgress = 0"
                         x-on:livewire-upload-finish="uploadProgress = 100"
                         x-on:livewire-upload-error="uploadProgress = 0"
                         x-on:livewire-upload-progress="uploadProgress = $event.detail.progress"
                         x-show="uploadProgress > 0 && uploadProgress < 100"
                         x-cloak
                         class="mt-2">
                        <div class="flex items-center gap-3">
                            <div class="flex-1 bg-gray-200 dark:bg-gray-700 rounded-full h-2.5 overflow-hidden">
                                <div class="bg-indigo-600 dark:bg-indigo-500 h-2.5 rounded-full transition-all duration-300 ease-out"
                                     :style="`width: ${uploadProgress}%`"></div>
                            </div>
                            <span class="text-sm font-medium text-gray-700 dark:text-gray-300 min-w-[3rem] text-right"
                                  x-text="`${Math.round(uploadProgress)}%`"></span>
                        </div>
                        <p class="mt-1 text-xs text-gray-600 dark:text-gray-400">Uploading files, please wait...</p>
                    </div>

                    @error('files.*')
                        <p class="mt-1.5 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                    @enderror
                </div>

                {{-- Upload Info Box --}}
                <div class="mt-3 p-3 bg-gray-50 dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700">
                    @if(Auth::check() && Auth::user()->hasAnyRole('superadmin', 'admin', 'employee'))
                        {{-- Employee View - No limits --}}
                        <div class="grid grid-cols-1 sm:grid-cols-2 gap-3 text-xs">
                            <div class="flex items-center gap-2">
                                <svg class="w-4 h-4 text-gray-400 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                                </svg>
                                <div>
                                    <span class="text-gray-500 dark:text-gray-400">Max size:</span>
                                    <span class="font-semibold text-gray-900 dark:text-white ml-1">{{ $settings['max_file_size_mb'] }}MB</span>
                                </div>
                            </div>
                            <div class="flex items-center gap-2">
                                <svg class="w-4 h-4 text-green-500 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                                </svg>
                                <div>
                                    <span class="text-gray-500 dark:text-gray-400">Uploaded:</span>
                                    <span class="font-semibold text-gray-900 dark:text-white ml-1">{{ $settings['current_file_count'] ?? 0 }}</span>
                                    <span class="text-green-600 dark:text-green-400 text-xs ml-1">(unlimited)</span>
                                </div>
                            </div>
                        </div>
                    @else
                        {{-- Customer View - With limits --}}
                        <div class="grid grid-cols-1 sm:grid-cols-3 gap-3 text-xs">
                            <div class="flex items-center gap-2">
                                <svg class="w-4 h-4 text-gray-400 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                                </svg>
                                <div>
                                    <span class="text-gray-500 dark:text-gray-400">Max size:</span>
                                    <span class="font-semibold text-gray-900 dark:text-white ml-1">{{ $settings['max_file_size_mb'] }}MB</span>
                                </div>
                            </div>
                            <div class="flex items-center gap-2">
                                <svg class="w-4 h-4 text-gray-400 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                                </svg>
                                <div>
                                    <span class="text-gray-500 dark:text-gray-400">Max files:</span>
                                    <span class="font-semibold text-gray-900 dark:text-white ml-1">{{ $settings['max_files_per_ticket'] }}</span>
                                </div>
                            </div>
                            <div class="flex items-center gap-2">
                                <svg class="w-4 h-4 text-gray-400 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                                </svg>
                                <div>
                                    <span class="text-gray-500 dark:text-gray-400">Uploaded:</span>
                                    <span class="font-semibold text-gray-900 dark:text-white ml-1">{{ $settings['current_file_count'] ?? 0 }}</span>
                                </div>
                            </div>
                        </div>
                    @endif

                    {{-- Selected Files Indicator --}}
                    @if(!empty($files))
                        <div class="mt-3 pt-3 border-t border-gray-200 dark:border-gray-700">
                            <div class="flex items-center gap-2 text-indigo-600 dark:text-indigo-400">
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                                </svg>
                                <span class="text-xs font-semibold">{{ count($files) }} file{{ count($files) > 1 ? 's' : '' }} selected and ready to upload</span>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
            @endif

            {{-- Submit Button --}}
            <div class="pt-2 border-t border-gray-200 dark:border-gray-700">
                <flux:button
                    icon="paper-airplane"
                    class="!bg-indigo-700 hover:!bg-indigo-600 !text-white !px-6 !py-2.5 !font-medium !rounded-lg !shadow-sm hover:!shadow-md !transition-all !duration-200"
                    type="submit"
                    wire:loading.attr="disabled"
                    wire:target="files"
                    id="submit-response-btn-{{ $ticket_id }}"
                >
                    <span wire:loading.remove wire:target="send,files">{{ __('Submit Response') }}</span>
                    <span wire:loading wire:target="files">{{ __('Uploading files...') }}</span>
                    <span wire:loading wire:target="send">{{ __('Submitting...') }}</span>
                </flux:button>
            </div>
        </div>
    </form>

    {{-- Typing Indicator Logic --}}
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const ticketId = {{ $ticket_id }};
            const contentTextarea = document.getElementById('content');
            const responseTypeSelect = document.getElementById('response_type');

            // Check if user is authenticated
            @guest
                return; // Guests don't broadcast typing
            @endguest

            // Check if Echo is available
            if (typeof window.Echo === 'undefined') {
                return;
            }

            let typingStartTimer = null;
            let typingStopTimer = null;
            let isCurrentlyBroadcasting = false;
            let currentTypingState = null; // Track 'public' or 'private'

            // Initialize global channel storage
            window.ticketChannels = window.ticketChannels || {};

            try {
                // Reuse existing channel or create new one
                if (!window.ticketChannels[ticketId]) {
                    window.ticketChannels[ticketId] = window.Echo.join('ticket.' + ticketId);
                }
                const channel = window.ticketChannels[ticketId];

                // Listen to textarea input
                if (contentTextarea) {
                    contentTextarea.addEventListener('input', function() {
                        handleTypingStart();
                    });

                    // Also listen to response type changes
                    if (responseTypeSelect) {
                        responseTypeSelect.addEventListener('change', function() {
                            // If user changes type while typing, update broadcast
                            if (isCurrentlyBroadcasting) {
                                stopTyping();
                                if (contentTextarea.value.length > 0) {
                                    handleTypingStart();
                                }
                            }
                        });
                    }
                }

                function handleTypingStart() {
                    // Determine if this is a public response or private note
                    const isPublic = !responseTypeSelect || responseTypeSelect.value != '1';
                    const newTypingState = isPublic ? 'public' : 'private';

                    // If typing state changed, stop previous broadcast
                    if (isCurrentlyBroadcasting && currentTypingState !== newTypingState) {
                        stopTyping();
                        currentTypingState = newTypingState;
                    }

                    // If already broadcasting, just reset the stop timer
                    if (isCurrentlyBroadcasting) {
                        // Reset stop timer - keep broadcasting while typing
                        if (typingStopTimer) {
                            clearTimeout(typingStopTimer);
                        }
                        typingStopTimer = setTimeout(function() {
                            stopTyping();
                        }, 30000);
                        return;
                    }

                    // Not broadcasting yet - check if we should start
                    if (!typingStartTimer) {
                        // First keystroke - start countdown
                        currentTypingState = newTypingState;

                        typingStartTimer = setTimeout(function() {
                            if (!isCurrentlyBroadcasting && contentTextarea.value.length > 0) {
                                startTyping(isPublic);
                                typingStartTimer = null;
                            }
                        }, 3000);
                    }

                    // Always set/reset stop timer (30 seconds of inactivity)
                    if (typingStopTimer) {
                        clearTimeout(typingStopTimer);
                    }
                    typingStopTimer = setTimeout(function() {
                        stopTyping();
                    }, 30000);
                }

                function startTyping(isPublic) {
                    isCurrentlyBroadcasting = true;

                    channel.whisper('typing', {
                        user: {
                            id: {{ Auth::id() ?? 'null' }},
                            name: '{{ Auth::user()->name ?? '' }}',
                            email: '{{ Auth::user()->email ?? '' }}',
                            email_hash: '{{ Auth::user() ? hash('sha256', strtolower(trim(Auth::user()->email))) : '' }}',
                            profile_photo_path: '{{ Auth::user()->profile_photo_path ?? '' }}'
                        },
                        isPublic: isPublic
                    });
                }

                function stopTyping() {
                    if (isCurrentlyBroadcasting) {
                        channel.whisper('stopped-typing', {
                            user: {
                                id: {{ Auth::id() ?? 'null' }}
                            }
                        });

                        isCurrentlyBroadcasting = false;
                        currentTypingState = null;
                    }

                    // Clear timers
                    if (typingStartTimer) {
                        clearTimeout(typingStartTimer);
                        typingStartTimer = null;
                    }

                    if (typingStopTimer) {
                        clearTimeout(typingStopTimer);
                        typingStopTimer = null;
                    }
                }

                // Stop typing when form is submitted
                const form = contentTextarea.closest('form');
                if (form) {
                    form.addEventListener('submit', function() {
                        stopTyping();
                    });
                }

                // Stop typing when user leaves the page
                window.addEventListener('beforeunload', function() {
                    stopTyping();
                });

            } catch (error) {
                // Silently fail
            }
        });
    </script>

    {{-- Collision Detection Modal --}}
    <div id="collision-warning-modal-{{ $ticket_id }}" tabindex="-1" aria-hidden="true" class="hidden overflow-y-auto overflow-x-hidden fixed top-0 right-0 left-0 z-50 justify-center items-center w-full md:inset-0 h-[calc(100%-1rem)] max-h-full bg-gray-900 bg-opacity-50">
        <div class="relative p-4 w-full max-w-md max-h-full">
            <div class="relative bg-white rounded-lg shadow-lg dark:bg-gray-800">
                {{-- Modal header --}}
                <div class="flex items-center justify-between p-4 md:p-5 border-b rounded-t dark:border-gray-700 border-gray-200">
                    <div class="flex items-center gap-3">
                        <div class="p-2 bg-amber-100 dark:bg-amber-900/30 rounded-lg">
                            <svg class="w-6 h-6 text-amber-600 dark:text-amber-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"></path>
                            </svg>
                        </div>
                        <h3 class="text-lg font-semibold text-gray-900 dark:text-white">
                            Another Employee is Typing
                        </h3>
                    </div>
                    <button type="button" class="text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm w-8 h-8 ms-auto inline-flex justify-center items-center dark:hover:bg-gray-700 dark:hover:text-white" onclick="closeCollisionModal({{ $ticket_id }})">
                        <svg class="w-3 h-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 14 14">
                            <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6"/>
                        </svg>
                        <span class="sr-only">Close modal</span>
                    </button>
                </div>
                {{-- Modal body --}}
                <div class="p-4 md:p-5">
                    <div class="mb-4">
                        <p class="text-sm text-gray-700 dark:text-gray-300 mb-3">
                            <span id="collision-agent-names-{{ $ticket_id }}" class="font-semibold"></span>
                            <span id="collision-verb-{{ $ticket_id }}">is</span> currently composing a response to this ticket.
                        </p>
                        <p class="text-sm text-gray-500 dark:text-gray-400">
                            You may want to wait a moment to avoid duplicate responses, or you can send your response anyway.
                        </p>
                    </div>
                    <div class="flex gap-3 mt-6">
                        <button type="button"
                                class="flex-1 text-gray-700 bg-gray-100 hover:bg-gray-200 dark:bg-gray-700 dark:text-gray-300 dark:hover:bg-gray-600 font-medium rounded-lg text-sm px-5 py-2.5 transition-colors"
                                onclick="closeCollisionModal({{ $ticket_id }})">
                            Wait
                        </button>
                        <button type="button"
                                class="flex-1 text-white bg-indigo-600 hover:bg-indigo-700 dark:bg-indigo-500 dark:hover:bg-indigo-600 font-medium rounded-lg text-sm px-5 py-2.5 transition-colors"
                                onclick="sendResponseAnyway({{ $ticket_id }})">
                            Send Anyway
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    {{-- Collision Detection Logic --}}
    <script>
        // Store typing users globally for collision detection
        window.ticketTypingUsers = window.ticketTypingUsers || {};
        window.ticketTypingUsers[{{ $ticket_id }}] = new Map();

        let pendingFormSubmit{{ $ticket_id }} = null;

        function closeCollisionModal(ticketId) {
            const modal = document.getElementById('collision-warning-modal-' + ticketId);
            if (modal) {
                modal.classList.add('hidden');
                modal.style.display = 'none';
            }
            pendingFormSubmit{{ $ticket_id }} = null;
        }

        function sendResponseAnyway(ticketId) {
            closeCollisionModal(ticketId);
            if (pendingFormSubmit{{ $ticket_id }}) {
                // Trigger Livewire form submission
                @this.send();
                pendingFormSubmit{{ $ticket_id }} = null;
            }
        }

        document.addEventListener('DOMContentLoaded', function() {
            const ticketId = {{ $ticket_id }};
            const form = document.querySelector('form[wire\\:submit\\.prevent="send"]');
            const submitBtn = document.getElementById('submit-response-btn-' + ticketId);

            @guest
                return; // Guests don't need collision detection
            @endguest

            if (typeof window.Echo === 'undefined') {
                return;
            }

            // Initialize global channel storage
            window.ticketChannels = window.ticketChannels || {};

            try {
                // Reuse existing channel or create new one
                if (!window.ticketChannels[ticketId]) {
                    window.ticketChannels[ticketId] = window.Echo.join('ticket.' + ticketId);
                }
                const channel = window.ticketChannels[ticketId];

                // Track typing users for collision detection
                channel.listenForWhisper('typing', (e) => {
                    const userId = e.user.id;
                    const currentUserId = {{ Auth::id() ?? 'null' }};

                    // Don't track current user
                    if (userId !== currentUserId) {
                        window.ticketTypingUsers[ticketId].set(userId, e.user);
                    }
                });

                channel.listenForWhisper('stopped-typing', (e) => {
                    window.ticketTypingUsers[ticketId].delete(e.user.id);
                });

                // Intercept form submission to check for collisions
                if (form && submitBtn) {
                    // Intercept button click before it triggers form submission
                    submitBtn.addEventListener('click', function(event) {
                        const typingUsers = window.ticketTypingUsers[ticketId];
                        const currentUserId = {{ Auth::id() ?? 'null' }};

                        // Filter out current user
                        const otherTypingUsers = Array.from(typingUsers.values()).filter(user => user.id !== currentUserId);

                        if (otherTypingUsers.length > 0) {
                            // Prevent button click from triggering form submission
                            event.preventDefault();
                            event.stopPropagation();
                            event.stopImmediatePropagation();

                            // Show collision modal
                            const modal = document.getElementById('collision-warning-modal-' + ticketId);
                            const namesEl = document.getElementById('collision-agent-names-' + ticketId);
                            const verbEl = document.getElementById('collision-verb-' + ticketId);

                            // Build names list
                            const names = otherTypingUsers.map(user => user.name);
                            if (names.length === 1) {
                                namesEl.textContent = names[0];
                                verbEl.textContent = 'is';
                            } else if (names.length === 2) {
                                namesEl.textContent = names[0] + ' and ' + names[1];
                                verbEl.textContent = 'are';
                            } else {
                                namesEl.textContent = names[0] + ' and ' + (names.length - 1) + ' other employees';
                                verbEl.textContent = 'are';
                            }

                            modal.classList.remove('hidden');
                            modal.style.display = 'flex'; // Explicitly set display to flex
                            pendingFormSubmit{{ $ticket_id }} = true;

                            return false;
                        }
                    }, true); // Capture phase - runs before other listeners
                }

            } catch (error) {
                // Silently fail
            }
        });
    </script>
</div>
