{{-- Recursive category row for hierarchical display --}}
<tr class="hover:bg-gray-50 dark:hover:bg-gray-700">
    <td class="px-6 py-4">
        <div class="flex items-center text-sm font-medium text-gray-900 dark:text-gray-100">
            {{-- Indentation based on depth --}}
            @if($depth > 0)
                <span class="inline-block" style="width: {{ $depth * 24 }}px;"></span>
                <svg class="w-4 h-4 text-gray-400 mr-1 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/>
                </svg>
            @endif

            {{-- Category name with children indicator --}}
            <span class="flex items-center">
                {{ $category->category_name }}
                @if($category->hasChildren())
                    <flux:badge color="zinc" size="sm" class="ml-2">
                        {{ $category->children->count() }} sub
                    </flux:badge>
                @endif
            </span>
        </div>
    </td>
    <td class="px-6 py-4 whitespace-nowrap">
        <flux:badge color="zinc" size="sm">{{ $category->type instanceof \BackedEnum ? ucfirst($category->type->value) : ucfirst($category->type) }}</flux:badge>
    </td>
    <td class="px-6 py-4 whitespace-nowrap">
        <div class="text-sm text-gray-500 dark:text-gray-400">
            {{ $category->uri }}
        </div>
    </td>
    <td class="px-6 py-4 whitespace-nowrap">
        @if($category->display)
            <flux:badge color="green" size="sm">Visible</flux:badge>
        @else
            <flux:badge color="gray" size="sm">Hidden</flux:badge>
        @endif
    </td>
    <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
        <div class="flex items-center justify-end space-x-2">
            @if($depth < 2)
                <a href="{{ route('settings.categories.create', ['parent' => $category->id, 'type' => $category->type instanceof \BackedEnum ? $category->type->value : $category->type]) }}"
                   class="text-green-600 hover:text-green-900 dark:text-green-400 dark:hover:text-green-300"
                   title="Add sub-category">
                    + Sub
                </a>
            @endif
            <a href="{{ route('settings.categories.edit', $category->id) }}"
               class="text-indigo-600 hover:text-indigo-900 dark:text-indigo-400 dark:hover:text-indigo-300"
               title="Edit category">
                Edit
            </a>
            <button wire:click="confirmDelete({{ $category->id }})"
                    class="text-red-600 hover:text-red-900 dark:text-red-400 dark:hover:text-red-300"
                    title="Delete category">
                Delete
            </button>
        </div>
    </td>
</tr>

{{-- Recursively render child categories --}}
@if($category->children && $category->children->count() > 0)
    @foreach($category->children as $child)
        @include('livewire.settings.categories.partials.category-row', [
            'category' => $child,
            'depth' => $depth + 1
        ])
    @endforeach
@endif
