<?php

use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Illuminate\Validation\Rule;
use Livewire\Attributes\Title;
use Livewire\Volt\Component;

new #[Title('API Details')] class extends Component {
    /**
     * The API details for the authenticated user.
     *
     * @var string
     */
    public string $email    = '';
    public string $api_token    = '';
    /**
     * Mount the component.
     */
    public function mount(): void
    {
        $this->email = Auth::user()->email;
        $this->api_token = Auth::user()->api_token;
    }
    /**
     * Create the API information for the currently authenticated user.
     */
     public function createAPIInformation(): void
    {
        $user = Auth::user();

        // Create a new token for the user
        $this->api_token = $user->createToken('auth_token')->plainTextToken;

        // Update the user's API token
        $user->update(['api_token' => $this->api_token]);

        $user->save();
        
        $this->dispatch('api-updated', name: $user->name);

        Session::flash('status', 'API Token has been updated.');
    }   
    /**
     * Update the API information for the currently authenticated user.
     */
    public function updateAPIInformation(): void
    {
        $user = Auth::user();

        // We grab the current token ID to delete it before creating a new one.
        $tokenId = $user->tokens()->where('name', 'auth_token')->where('tokenable_id', '=', $user->id)->first()->id;
        
        // Delete the old token
        $user->tokens()->where('id', $tokenId)->delete();

        // Create a new token
        $this->api_token = $user->createToken('auth_token')->plainTextToken;

        // Update the user's API token
        $user->update(['api_token' => $this->api_token]);

        $user->save();
        
        $this->dispatch('api-updated', name: $user->name);

        Session::flash('status', 'API Token has been updated.');
    }
}; 
?>

<section class="w-full">
    @include('partials.settings-heading')

    <x-settings.layout :heading="__('API Details')" :subheading="__('These details allows you to connect to third-party software.')">
        <div class="my-6 w-full space-y-6">

            <flux:input wire:model="email" :label="__('Email')" type="text" />
            <flux:input wire:model="api_token" :label="__('Token')" type="text" />
            
            <div class="flex items-center gap-4">
                <div class="flex items-center justify-end">
                    <form wire:submit="createAPIInformation" class="w-full mr-3">
                        <flux:button  type="submit" class="!bg-indigo-700 hover:!bg-indigo-500 !text-white w-full">{{ __('Create a Token') }}</flux:button>
                    </form>
                    <form wire:submit="updateAPIInformation" class="w-full">
                        <flux:button  type="submit" class="!bg-indigo-700 hover:!bg-indigo-500 !text-white w-full">{{ __('Generate New Token') }}</flux:button>
                    </form>
                </div>

                <x-action-message class="me-3" on="api-updated">
                    {{ __('Saved.') }}
                </x-action-message>
            </div>
            
        </div>

    </x-settings.layout>
</section>
