<div>
    <form wire:submit="change">
        <div class="col-span-full">
            <label for="department_id" class="block text-sm/6 font-medium text-gray-900 dark:text-white">{{ __('Department') }}</label>
            <div class="mt-2 grid grid-cols-1">
                <select id="department_id" name="department_id" class="col-start-1 row-start-1 w-full appearance-none rounded-md bg-white py-1.5 pr-8 pl-3 text-base text-gray-900 dark:text-white dark:bg-gray-900 dark:outline-gray-600 outline-1 -outline-offset-1 outline-gray-300 focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6" wire:model.live="department_id">
                    <option class="dark:text-white">Select the new department</option>
                    @foreach ($departments as $department)
                        <option class="block w-full dark:text-white"
                            value="{{ $department->id }}" wire:key="{{ $department->id }}">
                            {{ ucfirst($department->department_name) }}
                        </option>
                    @endforeach
                </select>
                @error('department_id') <em class="text-black dark:text-white">{{ $message }}</em>@enderror
            </div>
        </div>
        <flux:button class="!bg-indigo-700 hover:!bg-indigo-500 !text-white mt-3" type="submit">{{ __("Update") }}</flux:button>
    </form>
</div>