<div wire:poll.visible>
    <div class="flex w-full flex-1 flex-col gap-4 rounded-xl">
        <div class="grid auto-rows-min gap-4 md:grid-cols-3">
            @hasanyrole('employee|admin|superadmin')
                <div class="rounded-xl text-gray-900! dark:text-white">
                    <x-mary-stat
                        title="Open Tickets"
                        value="{{ $open_count }}"
                        icon="o-chat-bubble-left-ellipsis"
                        color="text-primary dark:text-white"
                        class="!bg-white border border-neutral-200 rounded-lg shadow-sm p-8 dark:!text-white dark:!bg-gray-900 dark:border-neutral-700" />
                </div>
                <div class="rounded-xl text-gray-900! dark:text-white">
                    <x-mary-stat
                        title="Assigned Tickets"
                        value="{{ $assigned_tickets }}"
                        icon="o-chat-bubble-left-right"
                        color="text-primary dark:text-white"
                        class="!bg-white border border-neutral-200 rounded-lg shadow-sm p-8 dark:!text-white dark:!bg-gray-900 dark:border-neutral-700" />
                </div>
                <div class="rounded-xl text-gray-900! dark:text-white">
                    <x-mary-stat
                        title="High Priority"
                        value="{{ $high_priority }}"
                        icon="o-shield-exclamation"
                        color="text-primary dark:text-white"
                        class="!bg-white border border-neutral-200 rounded-lg shadow-sm p-8 dark:!text-white dark:!bg-gray-900 dark:border-neutral-700" />
                </div>
            @else
            <div class="rounded-xl text-gray-900! dark:text-white">
                    <x-mary-stat
                        title="Awaiting My Response"
                        value="{{ $open_count }}"
                        icon="o-chat-bubble-left-ellipsis"
                        color="text-primary dark:text-white"
                        class="!bg-white border border-neutral-200 rounded-lg shadow-sm p-8 dark:!text-white dark:!bg-gray-900 dark:border-neutral-700" />
                </div>
                <div class="rounded-xl text-gray-900! dark:text-white">
                    <x-mary-stat
                        title="Awaiting Employee"
                        value="{{ $awaiting_count }}"
                        icon="o-users"
                        color="text-primary dark:text-white"
                        class="!bg-white border border-neutral-200 rounded-lg shadow-sm p-8 dark:!text-white dark:!bg-gray-900 dark:border-neutral-700" />
                </div>
                <div class="rounded-xl text-gray-900! dark:text-white">
                    <x-mary-stat
                        title="Closed"
                        value="{{ $closed_count }}"
                        icon="o-archive-box"
                        color="text-primary dark:text-white"
                        class="!bg-white border border-neutral-200 rounded-lg shadow-sm p-8 dark:!text-white dark:!bg-gray-900 dark:border-neutral-700" />
                </div>
            @endhasanyrole
        </div>
    </div>
</div>
