<div wire:poll.visible>
    <form wire:submit="change">
        <div class="col-span-full">
            <label for="employee_id" class="block text-sm/6 font-medium text-gray-900 dark:text-white">{{ __('Account Manager') }}</label>
            <div class="mt-2 grid grid-cols-1">
                <select id="employee_id" name="employee_id" class="col-start-1 row-start-1 w-full appearance-none rounded-md bg-white py-1.5 pr-8 pl-3 text-base text-gray-900 dark:text-white dark:bg-gray-900 dark:outline-gray-600 outline-1 -outline-offset-1 outline-gray-300 focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6" wire:model.live="employee_id">
                    <option class="dark:text-white">Select the Account Manager</option>
                    <option wire:key="0" value="0" class="dark:text-white">None</option>
                    @foreach ($employees as $employee)
                        <option  wire:key="{{ $employee->id }}" value="{{ $employee->id }}">{{ $employee->name }}</option>
                    @endforeach
                </select>
                @error('employee_id') <em class="text-black dark:text-white">{{ $message }}</em>@enderror
            </div>
            <label for="employee_id" class="block text-sm/6 font-medium text-gray-900 dark:text-white mt-4">Assign all tickets</label>
            <div class="mt-2 grid grid-cols-1">
                <select id="all_tickets" name="all_tickets" class="col-start-1 row-start-1 w-full appearance-none rounded-md bg-white py-1.5 pr-8 pl-3 text-base text-gray-900 dark:text-white dark:bg-gray-900 dark:outline-gray-600 outline-1 -outline-offset-1 outline-gray-300 focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6" wire:model.live="all_tickets">
                    <option class="dark:text-white">Select an option</option>
                    <option wire:key="0" value="0" class="dark:text-white">None</option>
                    <option wire:key="1" value="1">Yes</option>
                </select>
                @error('all_tickets') <em class="text-black dark:text-white">{{ $message }}</em>@enderror
            </div>
        </div>
        <flux:button class="!bg-indigo-700 hover:!bg-indigo-500 !text-white mt-3" type="submit">{{ __("Update") }}</flux:button>
    </form>
</div>
