<div wire:poll.visible>
    <div class="col-span-full">
        <div class="mt-2 grid grid-cols-1">
            <flux:fieldset>
                <flux:legend>Role:</flux:legend>
                <flux:description>Choose the role you wish the customer to have.</flux:description>
                
                <form wire:submit.prevent="updateRoles" class="space-y-4">
                    <div class="flex gap-4 *:gap-x-2">
                        <flux:radio.group wire:model="selectedRoles">
                            @foreach ($roles as $role)
                                @if($role->name != 'superadmin')
                                    <flux:radio value="{{ $role->name }}" id="role_{{ $role->id }}" label="{{ ucfirst($role->name) }}"></flux:checkbox>
                                @endif
                            @endforeach
                        </flux:radio.group>
                    </div>
                    <flux:button class="!bg-indigo-700 hover:!bg-indigo-500 !text-white mt-3" type="submit">{{ __("Update") }}</flux:button>
                </form>
            </flux:fieldset>
        </div>
    </div>
</div>