<div class="space-y-6">
    <!-- Header -->
    <div class="bg-white dark:bg-gray-800 shadow rounded-lg p-6">
        <h2 class="text-2xl font-bold text-gray-900 dark:text-white mb-2">Import Data into Ticaga</h2>
        <p class="text-gray-600 dark:text-gray-400">
            Import customers, tickets, and responses from CSV files or migrate from another helpdesk system.
        </p>
    </div>

    <!-- Import Sources -->
    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
        <!-- CSV Import -->
        @if($sources['csv']['enabled'] ?? false)
        <a href="{{ route('extensions.importer.csv.upload') }}"
           class="bg-white dark:bg-gray-800 shadow rounded-lg p-6 hover:shadow-lg transition-shadow cursor-pointer group">
            <div class="flex items-start space-x-4">
                <div class="flex-shrink-0">
                    <x-heroicon-o-document-text class="h-12 w-12 text-blue-500 group-hover:text-blue-600" />
                </div>
                <div class="flex-1">
                    <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-2">
                        {{ $sources['csv']['name'] }}
                    </h3>
                    <p class="text-gray-600 dark:text-gray-400 mb-4">
                        {{ $sources['csv']['description'] }}
                    </p>
                    <div class="text-sm text-gray-500 dark:text-gray-500 space-y-1">
                        <div class="flex items-center">
                            <x-heroicon-s-check-circle class="h-4 w-4 text-green-500 mr-2" />
                            <span>Field mapping</span>
                        </div>
                        <div class="flex items-center">
                            <x-heroicon-s-check-circle class="h-4 w-4 text-green-500 mr-2" />
                            <span>Preview before import</span>
                        </div>
                        <div class="flex items-center">
                            <x-heroicon-s-check-circle class="h-4 w-4 text-green-500 mr-2" />
                            <span>Batch processing</span>
                        </div>
                    </div>
                    <div class="mt-4">
                        <span class="inline-flex items-center text-blue-600 dark:text-blue-400 font-medium">
                            Start CSV Import
                            <x-heroicon-s-arrow-right class="ml-2 h-4 w-4" />
                        </span>
                    </div>
                </div>
            </div>
        </a>
        @endif

        <!-- Database Import -->
        @if($sources['database']['enabled'] ?? false)
        <a href="{{ route('extensions.importer.database.configure') }}"
           class="bg-white dark:bg-gray-800 shadow rounded-lg p-6 hover:shadow-lg transition-shadow cursor-pointer group">
            <div class="flex items-start space-x-4">
                <div class="flex-shrink-0">
                    <x-heroicon-o-circle-stack class="h-12 w-12 text-purple-500 group-hover:text-purple-600" />
                </div>
                <div class="flex-1">
                    <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-2">
                        {{ $sources['database']['name'] }}
                    </h3>
                    <p class="text-gray-600 dark:text-gray-400 mb-4">
                        {{ $sources['database']['description'] }}
                    </p>
                    <div class="text-sm text-gray-500 dark:text-gray-500 space-y-1">
                        <div class="flex items-center">
                            <x-heroicon-s-check-circle class="h-4 w-4 text-green-500 mr-2" />
                            <span>Direct database migration</span>
                        </div>
                        <div class="flex items-center">
                            <x-heroicon-s-check-circle class="h-4 w-4 text-green-500 mr-2" />
                            <span>Automatic ID mapping</span>
                        </div>
                        <div class="flex items-center">
                            <x-heroicon-s-check-circle class="h-4 w-4 text-green-500 mr-2" />
                            <span>Resume capability</span>
                        </div>
                    </div>
                    <div class="mt-4">
                        <span class="inline-flex items-center text-purple-600 dark:text-purple-400 font-medium">
                            Configure Database Import
                            <x-heroicon-s-arrow-right class="ml-2 h-4 w-4" />
                        </span>
                    </div>
                </div>
            </div>
        </a>
        @endif
    </div>

    <!-- Quick Actions -->
    <div class="bg-white dark:bg-gray-800 shadow rounded-lg p-6">
        <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">Quick Actions</h3>
        <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
            <a href="{{ route('extensions.importer.jobs.index') }}"
               class="flex items-center p-4 bg-gray-50 dark:bg-gray-700 rounded-lg hover:bg-gray-100 dark:hover:bg-gray-600 transition">
                <x-heroicon-o-list-bullet class="h-6 w-6 text-gray-600 dark:text-gray-300 mr-3" />
                <div>
                    <div class="font-medium text-gray-900 dark:text-white">Active Jobs</div>
                    <div class="text-sm text-gray-500 dark:text-gray-400">View ongoing imports</div>
                </div>
            </a>

            <a href="{{ route('extensions.importer.history') }}"
               class="flex items-center p-4 bg-gray-50 dark:bg-gray-700 rounded-lg hover:bg-gray-100 dark:hover:bg-gray-600 transition">
                <x-heroicon-o-clock class="h-6 w-6 text-gray-600 dark:text-gray-300 mr-3" />
                <div>
                    <div class="font-medium text-gray-900 dark:text-white">Import History</div>
                    <div class="text-sm text-gray-500 dark:text-gray-400">View past imports</div>
                </div>
            </a>

            <a href="https://docs.ticaga.com/extensions/importer" target="_blank"
               class="flex items-center p-4 bg-gray-50 dark:bg-gray-700 rounded-lg hover:bg-gray-100 dark:hover:bg-gray-600 transition">
                <x-heroicon-o-book-open class="h-6 w-6 text-gray-600 dark:text-gray-300 mr-3" />
                <div>
                    <div class="font-medium text-gray-900 dark:text-white">Documentation</div>
                    <div class="text-sm text-gray-500 dark:text-gray-400">Import guides & help</div>
                </div>
            </a>
        </div>
    </div>
</div>