@php use Illuminate\Support\Facades\Auth; @endphp
<div>
    <flux:heading size="xl" level="1">
        {{ __("Departments") }}
    </flux:heading>
@auth
    @hasanyrole('superadmin|admin')
    <flux:text class="mt-2 text-base">
        <flux:button href="#" class="!bg-indigo-700 hover:!bg-indigo-500 !text-white" data-modal-target="new-department-modal" data-modal-toggle="new-department-modal">
            {{ __("Create Department") }}
        </flux:button>
    </flux:text>
    @endhasanyrole
@endauth
    <flux:separator variant="subtle" class="mt-3" />
    @if($department_count  != '0')
        <ul role="list" class="grid grid-cols-1 gap-6 sm:grid-cols-2 lg:grid-cols-3 mt-3">
            @foreach($departments as $department)
                @if(Auth::check() and Auth::user()->hasAnyRole('superadmin','admin', 'employee'))
                    <li class="col-span-1 divide-y divide-gray-200 shadow-md sm:rounded-lg mt-3 border border-neutral-200 rounded-lg shadow-sm dark:bg-gray-800 dark:border-neutral-700">
                        <a href="{{ config('app.url') }}/tickets/open/{{ $department->slug }}">
                            <div class="flex w-full items-center justify-between space-x-6 p-6">
                                <div class="flex-1 truncate">
                                    <div class="flex items-center space-x-3">
                                        <h3 class="truncate text-md font-medium text-gray-900 dark:text-white font-bold">
                                            {{ $department->department_name }}
                                        </h3>
                                    </div>
                                    
                                    <p class="mt-1 truncate text-sm text-gray-500 dark:text-white">
                                        @if($department->department_description != '')
                                            {{ $department->department_description }}
                                        @else
                                            &nbsp;
                                        @endif
                                    </p>
                                </div>
                            </div>
                        </a>
                        <div class="rounded-b-lg">
                            <div class="-mt-px flex divide-x divide-gray-200 dark:divide-gray-100/10 dark:border-gray-100/10 border-t-1">
                                @if(Auth::check() and Auth::user()->hasAnyRole('superadmin|admin'))
                                    <div class="flex w-0 flex-1 dark:text-white">
                                        <a href="{{ config('app.url') }}/departments/edit/{{ $department->id }}" class="relative -mr-px inline-flex w-0 flex-1 items-center justify-center gap-x-3 rounded-bl-lg border border-transparent py-4 text-sm font-semibold text-gray-900 dark:text-white">
                                            <x-mary-icon name="lucide.notebook-pen" />
                                            {{ __('Edit') }}
                                        </a>
                                    </div>
                                @endif
                                @if($department->soft_deleted != '1')
                                    @if(Auth::check() and Auth::user()->hasAnyRole('superadmin|admin'))
                                        <div class="-ml-px flex w-0 flex-1 dark:text-white">
                                            <a href="#" wire:click="soft_delete({{ $department->id }})"
                                                wire:confirm="Are you sure you want to delete this department?" class="relative inline-flex w-0 flex-1 items-center justify-center gap-x-3 rounded-br-lg border border-transparent py-4 text-sm font-semibold text-gray-900 dark:text-white">
                                                <x-mary-icon name="lucide.trash-2" />
                                                Remove
                                            </a>
                                        </div>
                                    @endif
                                @endif
                                @if($department->soft_deleted == '1')
                                    @if(Auth::check() and Auth::user()->hasAnyRole('superadmin'))
                                        <div class="-ml-px flex w-0 flex-1 dark:text-white">
                                            <a href="#" wire:click="restore({{ $department->id }})" wire:confirm="Are you sure you want to restore this department?" class="relative inline-flex w-0 flex-1 items-center justify-center gap-x-3 rounded-br-lg border border-transparent py-4 text-sm font-semibold text-gray-900 dark:text-white">
                                            <x-mary-icon name="lucide.recycle" />
                                                Restore
                                            </a>
                                        </div>
                                        <div class="-ml-px flex w-0 flex-1 dark:text-white">
                                            <a href="#" wire:click="delete({{ $department->id }})" wire:confirm="Are you sure you want to delete this department?" class="relative inline-flex w-0 flex-1 items-center justify-center gap-x-3 rounded-br-lg border border-transparent py-4 text-sm font-semibold text-gray-900 dark:text-white">
                                                <x-mary-icon name="lucide.trash-2" />
                                                Remove
                                            </a>
                                        </div>
                                    @endif
                                @endif
                            </div>
                        </div>
                    </li>
                @else
                    @if($department->is_disabled != '1')
                        <li class="col-span-1 divide-y divide-gray-200 shadow-md sm:rounded-lg mt-3 border border-neutral-200 rounded-lg shadow-sm dark:bg-gray-800 dark:border-neutral-700">
                            <a href="{{ config('app.url') }}/tickets/open/{{ $department->slug }}">
                                <div class="flex w-full items-center justify-between space-x-6 p-6">
                                    <div class="flex-1 truncate">
                                        <div class="flex items-center space-x-3">
                                            <h3 class="truncate text-md font-medium text-gray-900 dark:text-white font-bold">
                                                {{ $department->department_name }}
                                            </h3>
                                        </div>
                                            
                                        @if($department->department_description != '')
                                            <p class="mt-1 truncate text-sm text-gray-500 dark:text-white">
                                                {{ $department->department_description }}
                                            </p>
                                        @endif
                                    </div>
                                </div>
                            </a>
                        </li>
                    @endif
                @endif
            @endforeach
        </ul>
    @else
    <div class="mx-auto overflow-x-auto">
        <div class="overflow-hidden shadow-xl sm:rounded-lg">
            <div cass="flex flex-col">
                <div class="overflow-x-auto">
                    <div class="inline-block min-w-full">
                        <div class="overflow-hidden">
                            <div class="mt-4">
                                <div class="p-4 mb-4 text-sm text-blue-800 bg-blue-50 border border-blue-300 rounded-lg dark:shadow-sm dark:bg-gray-800 dark:text-white dark:border-neutral-700" role="alert">
                                    {{ __("Currently there are no departments.") }}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endif
    <div id="new-department-modal" data-modal-backdrop="static" tabindex="-1" aria-hidden="true" class="hidden overflow-y-auto overflow-x-hidden fixed top-0 right-0 left-0 z-50 justify-center items-center w-full md:inset-0 h-[calc(100%-1rem)] max-h-full">
        <div class="relative p-4 w-full max-w-2xl max-h-full">
            <!-- Modal content -->
            <div class="relative bg-white rounded-lg shadow-sm dark:bg-gray-700">
                <!-- Modal header -->
                <div class="flex items-center justify-between p-4 md:p-5 border-b rounded-t dark:border-gray-600 border-gray-200">
                    <h3 class="text-xl font-semibold text-gray-900 dark:text-white">
                        New Department
                    </h3>
                    <button type="button" class="end-2.5 text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm w-8 h-8 ms-auto inline-flex justify-center items-center dark:hover:bg-gray-600 dark:hover:text-white" data-modal-hide="new-department-modal">
                        <svg class="w-3 h-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 14 14">
                            <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6"/>
                        </svg>
                        <span class="sr-only">Close modal</span>
                    </button>
                </div>
                <!-- Modal body -->
                <div class="p-4 md:p-5">
                    <livewire:departments.create :isModal="true"/>
                </div>
            </div>
        </div>
    </div>

    <script>
        // Initialize Flowbite modals when the component loads
        document.addEventListener('livewire:navigated', () => {
            if (window.initFlowbite) {
                window.initFlowbite();
            }
        });

        // Also initialize on initial page load
        document.addEventListener('DOMContentLoaded', () => {
            if (window.initFlowbite) {
                window.initFlowbite();
            }
        });
    </script>
</div>