<div>
    @if(!$isModal)
        <flux:heading size="xl" level="1" class="font-bold text-gray-900 dark:text-white">
            {{ __('Create Department') }}
        </flux:heading>
        <flux:text class="text-gray-600 dark:text-gray-400">
            {{ __('Add a new department to organize your tickets') }}
        </flux:text>
        <flux:separator variant="subtle" class="mt-3" />
    @endif

    <form wire:submit="save">

            <div class="col-span-full">
                <div class="mt-2">
                    <flux:input label="{{ __('Department Name') }}" wire:model.live="department_name" />
                </div>
            </div>

            <div class="col-span-full mt-5">
                <div class="mt-2">
                    <flux:input label="{{ __('Description') }}" wire:model.live="department_description" />
                </div>
            </div>

            <div class="col-span-full mt-5">
                <div class="mt-2">
                    <flux:input label="{{ __('Department Slug') }}" badge="Optional" wire:model.live="slug" />
                </div>
                <p class="mt-3 text-sm/6 text-gray-600 dark:text-white">{{ config('app.url') }}/tickets/open/{{ Str::of($slug ?: $department_name)->slug('-') }}</p>
            </div>

            <div class="grid grid-cols-1 gap-x-6 gap-y-8 sm:grid-cols-6 mt-4">

                <div class="sm:col-span-3 mt-5">
                    <div class="mt-2">
                        <flux:input label="{{ __('Department Email Address') }}" wire:model.live="department_email" />
                    </div>
                </div>

                <div class="sm:col-span-3 mt-5">
                    <label for="mail_account_id" class="block text-sm/6 font-medium text-gray-900 dark:text-white">
                        {{ __('Mail Account') }}
                        <span class="text-xs text-gray-500 dark:text-gray-400 font-normal">({{ __('Optional') }})</span>
                    </label>
                    <div class="mt-2 grid grid-cols-1">
                        <select id="mail_account_id" name="mail_account_id" class="col-start-1 row-start-1 w-full appearance-none rounded-md bg-white py-1.5 pr-8 pl-3 text-base text-gray-900 dark:text-white dark:bg-gray-800 dark:outline-gray-600 outline-1 -outline-offset-1 outline-gray-300 focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6" wire:model.live="mail_account_id">
                            <option value="">{{ __('Use default mail account') }}</option>
                            @foreach($mailAccounts as $account)
                                <option value="{{ $account->id }}" wire:key="mail-{{ $account->id }}">
                                    {{ $account->name }} ({{ $account->email }})@if($account->is_default) - Default @endif
                                </option>
                            @endforeach
                        </select>
                        @error('mail_account_id') <em class="text-black dark:text-white">{{ $message }}</em>@enderror
                    </div>
                    @auth
                        @if(Auth::user()->hasRole('superadmin'))
                            <p class="mt-2 text-sm text-gray-500 dark:text-gray-400">
                                <a href="{{ route('settings.mail-settings') }}" class="text-indigo-600 hover:text-indigo-500 dark:text-indigo-400" wire:navigate>
                                    <x-lucide-settings class="inline w-4 h-4" /> {{ __('Manage mail accounts') }}
                                </a>
                            </p>
                        @endif
                    @endauth
                </div>
            </div>

            <div class="grid grid-cols-1 gap-x-6 gap-y-8 sm:grid-cols-6 mt-4">
                <div class="sm:col-span-3 mt-5">
                    <label for="allows_high_priority" class="block text-sm/6 font-medium text-gray-900 dark:text-white">{{ __('Allow High Priorities') }}</label>
                    <div class="mt-2 grid grid-cols-1">
                        <select id="allows_high_priority" name="allows_high_priority" class="col-start-1 row-start-1 w-full appearance-none rounded-md bg-white py-1.5 pr-8 pl-3 text-base text-gray-900 dark:text-white dark:bg-gray-800 dark:outline-gray-600 outline-1 -outline-offset-1 outline-gray-300 focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6" wire:model.live="allows_high_priority">
                            <option>-</option>
                            <option value="0" wire:key="0">
                                No
                            </option>
                            <option value="1" wire:key="1">
                                Yes
                            </option>
                            <option value="3" wire:key="3">
                                Disable Priorities
                            </option>
                        </select>
                        @error('allows_high_priority') <em class="text-black dark:text-white">{{ $message }}</em>@enderror
                    </div>
                </div>
            </div>

            <div class="grid grid-cols-1 gap-x-6 gap-y-8 sm:grid-cols-6">
                <div class="sm:col-span-3 mt-5">
                    <label for="is_public" class="block text-sm/6 font-medium text-gray-900 dark:text-white">{{ __('Who can open tickets?') }}</label>
                    <div class="mt-2 grid grid-cols-1">
                        <select id="is_public" name="is_public" class="col-start-1 row-start-1 w-full appearance-none rounded-md bg-white py-1.5 pr-8 pl-3 text-base text-gray-900 dark:text-white dark:bg-gray-800 dark:outline-gray-600 outline-1 -outline-offset-1 outline-gray-300 focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6" wire:model.live="is_public">
                            <option>-</option>
                            <option value="0" wire:key="0">
                                {{ __('Private shared link') }}
                            </option>
                            <option value="1" wire:key="1">
                                {{ __('Public') }}
                            </option>
                            <option value="2" wire:key="2">
                                {{ __('Customers only') }}
                            </option>
                        </select>
                        @error('is_public') <em class="dark:text-white">{{ $message }}</em>@enderror
                    </div>
                </div>

                <div class="sm:col-span-3 mt-5">
                    <label for="is_disabled" class="block text-sm/6 font-medium text-gray-900 dark:text-white">{{ __('Is the department visible?') }}</label>
                    <div class="mt-2 grid grid-cols-1">
                        <select id="is_disabled" name="is_disabled" class="col-start-1 row-start-1 w-full appearance-none rounded-md bg-white dark:text-white dark:bg-gray-800 dark:outline-gray-600 py-1.5 pr-8 pl-3 text-base text-gray-900 dark:text-white-900 outline-1 -outline-offset-1 outline-gray-300 focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6" wire:model.live="is_disabled">
                            <option>-</option>
                            <option value="0" wire:key="0">
                                Visible
                            </option>
                            <option value="1" wire:key="1">
                                Disabled
                            </option>
                        </select>
                        @error('is_disabled') <em class="dark:text-white">{{ $message }}</em>@enderror
                    </div>
                </div>
            </div>

            <div class="grid grid-cols-1 gap-x-6 gap-y-8 sm:grid-cols-6">
                <div class="sm:col-span-3 mt-5">
                    <label for="cc_enabled" class="block text-sm/6 font-medium text-gray-900 dark:text-white">{{ __('Enable Carbon Copy (CC)') }}</label>
                    <div class="mt-2 grid grid-cols-1">
                        <select id="cc_enabled" name="cc_enabled" class="col-start-1 row-start-1 w-full appearance-none rounded-md bg-white py-1.5 pr-8 pl-3 text-base text-gray-900 dark:text-white dark:bg-gray-800 dark:outline-gray-600 outline-1 -outline-offset-1 outline-gray-300 focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6" wire:model.live="cc_enabled">
                            <option value="1" wire:key="1">
                                {{ __('Enabled') }}
                            </option>
                            <option value="0" wire:key="0">
                                {{ __('Disabled') }}
                            </option>
                        </select>
                        @error('cc_enabled') <em class="text-black dark:text-white">{{ $message }}</em>@enderror
                    </div>
                </div>
            </div>

        <flux:button class="!bg-indigo-700 hover:!bg-indigo-500 !text-white mt-5" type="submit">Create</flux:button>
    </form>
</div>