<style>
    /* Fix file input button border radius */
    #file-upload::file-selector-button {
        border-top-left-radius: 0.5rem;
        border-bottom-left-radius: 0.5rem;
    }

    /* For Safari support */
    #file-upload::-webkit-file-upload-button {
        border-top-left-radius: 0.5rem;
        border-bottom-left-radius: 0.5rem;
    }
</style>

<div class="space-y-5">
    {{-- Upload Section --}}
    @if($this->canUpload && $settings['enabled'])
        <div class="bg-white dark:bg-gray-900 border border-gray-200 dark:border-gray-700 rounded-lg shadow-sm p-6">
            {{-- Section Header --}}
            <div class="flex items-center gap-3 mb-5 pb-4 border-b border-gray-200 dark:border-gray-700">
                <div class="p-2.5 bg-indigo-50 dark:bg-indigo-900/30 rounded-lg">
                    <svg class="w-5 h-5 text-indigo-600 dark:text-indigo-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15.172 7l-6.586 6.586a2 2 0 102.828 2.828l6.414-6.586a4 4 0 00-5.656-5.656l-6.415 6.585a6 6 0 108.486 8.486L20.5 13"></path>
                    </svg>
                </div>
                <div class="flex-1">
                    <h3 class="text-lg font-semibold text-gray-900 dark:text-white">Attachments</h3>
                    <p class="text-sm text-gray-500 dark:text-gray-400">Upload files to support your request</p>
                </div>
                <div class="text-right">
                    <div class="text-sm font-medium text-gray-900 dark:text-white">{{ $uploadedAttachments->count() }} / {{ $this->maxFiles }}</div>
                    <div class="text-xs text-gray-500 dark:text-gray-400">files uploaded</div>
                </div>
            </div>

            <div class="space-y-5">
                {{-- File Upload Input --}}
                <div>
                    <label for="file-upload" class="flex items-center gap-2 text-sm font-semibold text-gray-900 dark:text-white mb-2">
                        <svg class="w-4 h-4 text-indigo-600 dark:text-indigo-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 13h6m-3-3v6m5 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                        </svg>
                        Select Files
                    </label>
                    <div class="ml-4">
                        <input
                            type="file"
                            id="file-upload"
                            wire:model="files"
                            multiple
                            accept="{{ $this->getAcceptedFileTypes() }}"
                            class="block w-full text-sm text-gray-900 dark:text-gray-300 border border-gray-300 dark:border-gray-600 rounded-lg cursor-pointer bg-gray-50 dark:bg-gray-800 focus:outline-none focus:ring-2 focus:ring-indigo-600 dark:focus:ring-indigo-500 file:mr-4 file:py-2.5 file:px-4 file:border-0 file:text-sm file:font-semibold file:bg-gray-800 dark:file:bg-gray-700 file:text-white dark:file:text-white hover:file:bg-gray-700 dark:hover:file:bg-gray-600 file:cursor-pointer file:rounded-lg transition-all duration-200"
                        />

                        {{-- Upload Progress Bar --}}
                        <div x-data="{ uploadProgress: 0 }"
                             x-on:livewire-upload-start="uploadProgress = 0"
                             x-on:livewire-upload-finish="uploadProgress = 100"
                             x-on:livewire-upload-error="uploadProgress = 0"
                             x-on:livewire-upload-progress="uploadProgress = $event.detail.progress"
                             x-show="uploadProgress > 0 && uploadProgress < 100"
                             x-cloak
                             class="mt-2">
                            <div class="flex items-center gap-3">
                                <div class="flex-1 bg-gray-200 dark:bg-gray-700 rounded-full h-2.5 overflow-hidden">
                                    <div class="bg-indigo-600 dark:bg-indigo-500 h-2.5 rounded-full transition-all duration-300 ease-out"
                                         :style="`width: ${uploadProgress}%`"></div>
                                </div>
                                <span class="text-sm font-medium text-gray-700 dark:text-gray-300 min-w-[3rem] text-right"
                                      x-text="`${Math.round(uploadProgress)}%`"></span>
                            </div>
                            <p class="mt-1 text-xs text-gray-600 dark:text-gray-400">Uploading files, please wait...</p>
                        </div>

                        @error('files.*')
                            <p class="mt-1.5 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                        @enderror
                    </div>

                    {{-- Selected Files Preview --}}
                    @if(!empty($files))
                        <div class="mt-3 ml-4 space-y-2">
                            <div class="flex items-center gap-2 text-sm font-semibold text-gray-900 dark:text-white">
                                <svg class="w-4 h-4 text-indigo-600 dark:text-indigo-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                </svg>
                                Selected ({{ count($files) }})
                            </div>
                            @foreach($files as $file)
                                <div class="flex items-center gap-3 p-3 bg-gray-50 dark:bg-gray-800 border border-gray-200 dark:border-gray-700 rounded-lg">
                                    <svg class="w-5 h-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z"></path>
                                    </svg>
                                    <div class="flex-1 min-w-0">
                                        <div class="text-sm font-medium text-gray-900 dark:text-white truncate">{{ $file->getClientOriginalName() }}</div>
                                        <div class="text-xs text-gray-500 dark:text-gray-400">{{ number_format($file->getSize() / 1024 / 1024, 2) }} MB</div>
                                    </div>
                                    <svg class="w-5 h-5 text-green-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                                    </svg>
                                </div>
                            @endforeach

                            {{-- Upload Button --}}
                            <button
                                wire:click="upload"
                                :disabled="$uploading"
                                class="w-full inline-flex items-center justify-center gap-2 px-6 py-3 bg-indigo-700 hover:bg-indigo-600 text-white font-medium rounded-lg shadow-sm hover:shadow-md transition-all duration-200 disabled:opacity-50 disabled:cursor-not-allowed"
                            >
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M15 13l-3-3m0 0l-3 3m3-3v12"></path>
                                </svg>
                                Upload {{ count($files) }} File{{ count($files) > 1 ? 's' : '' }}
                            </button>
                        </div>
                    @endif

                    {{-- Upload Guidelines --}}
                    <div class="mt-3 p-3 bg-gray-50 dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700">
                        <div class="grid grid-cols-1 sm:grid-cols-3 gap-3 text-xs">
                            <div class="flex items-start gap-2">
                                <svg class="w-4 h-4 text-gray-400 flex-shrink-0 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                                </svg>
                                <div>
                                    <span class="text-gray-500 dark:text-gray-400">Max size:</span>
                                    <span class="font-semibold text-gray-900 dark:text-white ml-1">{{ $settings['max_file_size_mb'] }}MB</span>
                                </div>
                            </div>
                            <div class="flex items-start gap-2">
                                <svg class="w-4 h-4 text-gray-400 flex-shrink-0 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                                </svg>
                                <div>
                                    <span class="text-gray-500 dark:text-gray-400">Max files:</span>
                                    <span class="font-semibold text-gray-900 dark:text-white ml-1">{{ $this->maxFiles }}</span>
                                </div>
                            </div>
                            <div class="flex items-start gap-2">
                                <svg class="w-4 h-4 text-gray-400 flex-shrink-0 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                                </svg>
                                <div>
                                    <span class="text-gray-500 dark:text-gray-400">Uploaded:</span>
                                    <span class="font-semibold text-gray-900 dark:text-white ml-1">{{ $uploadedAttachments->count() }}</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                {{-- Upload Progress Indicator --}}
                @if($uploading)
                    <div class="ml-4 flex items-center gap-3 p-4 bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-800 rounded-lg">
                        <svg class="w-5 h-5 text-blue-600 dark:text-blue-400 animate-spin" fill="none" viewBox="0 0 24 24">
                            <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                            <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                        </svg>
                        <div>
                            <div class="text-sm font-medium text-blue-900 dark:text-blue-200">Uploading files...</div>
                            <div class="text-xs text-blue-700 dark:text-blue-300">Please wait while your files are being uploaded</div>
                        </div>
                    </div>
                @endif
            </div>
        </div>
    @elseif(!$settings['enabled'])
        <div class="flex items-start gap-3 p-4 rounded-lg bg-yellow-50 dark:bg-yellow-900/20 border border-yellow-200 dark:border-yellow-800">
            <svg class="w-5 h-5 text-yellow-600 dark:text-yellow-400 flex-shrink-0 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
                <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd"></path>
            </svg>
            <div>
                <p class="text-sm font-semibold text-yellow-800 dark:text-yellow-200">Attachments Disabled</p>
                <p class="text-xs text-yellow-700 dark:text-yellow-300 mt-1">File attachments are disabled for this department.</p>
            </div>
        </div>
    @else
        <div class="flex items-start gap-3 p-4 rounded-lg bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-800">
            <svg class="w-5 h-5 text-blue-600 dark:text-blue-400 flex-shrink-0 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
                <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd"></path>
            </svg>
            <div>
                <p class="text-sm font-semibold text-blue-800 dark:text-blue-200">Attachment Limit Reached</p>
                <p class="text-xs text-blue-700 dark:text-blue-300 mt-1">Maximum number of attachments ({{ $this->maxFiles }}) has been reached for this ticket.</p>
            </div>
        </div>
    @endif

    {{-- Existing Attachments List --}}
    @if($uploadedAttachments->count() > 0)
        <div class="bg-white dark:bg-gray-900 border border-gray-200 dark:border-gray-700 rounded-lg shadow-sm p-6">
            {{-- Section Header --}}
            <div class="flex items-center justify-between mb-5 pb-4 border-b border-gray-200 dark:border-gray-700">
                <div class="flex items-center gap-3">
                    <div class="p-2.5 bg-green-50 dark:bg-green-900/30 rounded-lg">
                        <svg class="w-5 h-5 text-green-600 dark:text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                        </svg>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-gray-900 dark:text-white">Uploaded Files</h3>
                        <p class="text-sm text-gray-500 dark:text-gray-400">{{ $uploadedAttachments->count() }} file{{ $uploadedAttachments->count() > 1 ? 's' : '' }} attached to this ticket</p>
                    </div>
                </div>
            </div>

            <div class="space-y-3">
                @foreach($uploadedAttachments as $attachment)
                    <div class="flex items-center justify-between p-4 bg-gray-50 dark:bg-gray-800 border border-gray-200 dark:border-gray-700 rounded-lg hover:shadow-sm transition-shadow duration-200">
                        <div class="flex items-center gap-4 flex-1 min-w-0">
                            {{-- File Icon/Thumbnail --}}
                            @if($attachment->isImage() && $attachment->thumbnail_path)
                                <img
                                    src="{{ $attachment->getThumbnailUrl() }}"
                                    alt="{{ $attachment->original_filename }}"
                                    class="w-14 h-14 object-cover rounded-lg border border-gray-200 dark:border-gray-700"
                                />
                            @else
                                <div class="w-14 h-14 flex items-center justify-center bg-white dark:bg-gray-700 border border-gray-200 dark:border-gray-600 rounded-lg">
                                    @if($attachment->isPdf())
                                        <svg class="w-7 h-7 text-red-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z"></path>
                                        </svg>
                                    @elseif($attachment->isImage())
                                        <svg class="w-7 h-7 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                                        </svg>
                                    @elseif($attachment->isVideo())
                                        <svg class="w-7 h-7 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 10l4.553-2.276A1 1 0 0121 8.618v6.764a1 1 0 01-1.447.894L15 14M5 18h8a2 2 0 002-2V8a2 2 0 00-2-2H5a2 2 0 00-2 2v8a2 2 0 002 2z"></path>
                                        </svg>
                                    @else
                                        <svg class="w-7 h-7 text-gray-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                        </svg>
                                    @endif
                                </div>
                            @endif

                            {{-- File Info --}}
                            <div class="flex-1 min-w-0">
                                <div class="font-medium text-sm text-gray-900 dark:text-white truncate">
                                    {{ $attachment->original_filename }}
                                </div>
                                <div class="flex items-center gap-2 mt-1 text-xs text-gray-500 dark:text-gray-400">
                                    <span class="inline-flex items-center gap-1">
                                        <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 7v10c0 2.21 3.582 4 8 4s8-1.79 8-4V7M4 7c0 2.21 3.582 4 8 4s8-1.79 8-4M4 7c0-2.21 3.582-4 8-4s8 1.79 8 4"></path>
                                        </svg>
                                        {{ $attachment->formatted_size }}
                                    </span>
                                    <span>•</span>
                                    <span class="inline-flex items-center gap-1">
                                        <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                        </svg>
                                        {{ $attachment->created_at->diffForHumans() }}
                                    </span>
                                    @if($attachment->download_count > 0)
                                        <span>•</span>
                                        <span class="inline-flex items-center gap-1">
                                            <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-4l-4 4m0 0l-4-4m4 4V4"></path>
                                            </svg>
                                            {{ $attachment->download_count }} downloads
                                        </span>
                                    @endif
                                </div>

                                {{-- Virus Scan Status --}}
                                @if($attachment->needsVirusScan())
                                    <span class="inline-flex items-center gap-1.5 mt-2 px-2.5 py-1 bg-yellow-100 dark:bg-yellow-900/30 text-yellow-800 dark:text-yellow-300 text-xs font-medium rounded-full">
                                        <svg class="w-3 h-3 animate-spin" fill="none" viewBox="0 0 24 24">
                                            <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                                            <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                                        </svg>
                                        Scanning...
                                    </span>
                                @elseif(!$attachment->isSafe())
                                    <span class="inline-flex items-center gap-1.5 mt-2 px-2.5 py-1 bg-red-100 dark:bg-red-900/30 text-red-800 dark:text-red-300 text-xs font-medium rounded-full">
                                        <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"></path>
                                        </svg>
                                        Virus detected
                                    </span>
                                @elseif($attachment->virus_scanned)
                                    <span class="inline-flex items-center gap-1.5 mt-2 px-2.5 py-1 bg-green-100 dark:bg-green-900/30 text-green-800 dark:text-green-300 text-xs font-medium rounded-full">
                                        <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                        </svg>
                                        Safe
                                    </span>
                                @endif
                            </div>
                        </div>

                        {{-- Actions --}}
                        <div class="flex items-center gap-2 ml-4">
                            {{-- Download Button --}}
                            @if($attachment->isSafe())
                                <a
                                    href="{{ route('attachments.download', $attachment->id) }}"
                                    target="_blank"
                                    class="p-2 text-blue-600 hover:text-blue-700 dark:text-blue-400 dark:hover:text-blue-300 hover:bg-blue-50 dark:hover:bg-blue-900/30 rounded-lg transition-colors duration-200"
                                    title="Download file"
                                >
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-4l-4 4m0 0l-4-4m4 4V4"></path>
                                    </svg>
                                </a>
                            @endif

                            {{-- Delete Button --}}
                            @can('delete', $attachment)
                                <button
                                    wire:click="deleteAttachment({{ $attachment->id }})"
                                    wire:confirm="Are you sure you want to delete this attachment?"
                                    class="p-2 text-red-600 hover:text-red-700 dark:text-red-400 dark:hover:text-red-300 hover:bg-red-50 dark:hover:bg-red-900/30 rounded-lg transition-colors duration-200"
                                    title="Delete file"
                                >
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path>
                                    </svg>
                                </button>
                            @endcan
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    @endif

    {{-- Storage Quota Info (for customers) --}}
    @if(!auth()->user()->hasAnyRole(['superadmin', 'admin', 'employee']))
        @php
            $quotaMb = auth()->user()->storage_quota_mb ?? $settings['storage_quota_mb'] ?? 100;
            $usedMb = round(auth()->user()->storage_used_bytes / 1024 / 1024, 2);
            $percentUsed = ($usedMb / $quotaMb) * 100;
        @endphp

        <div class="bg-white dark:bg-gray-900 border border-gray-200 dark:border-gray-700 rounded-lg shadow-sm p-6">
            <div class="flex items-center gap-3 mb-4">
                <div class="p-2.5 bg-blue-50 dark:bg-blue-900/30 rounded-lg">
                    <svg class="w-5 h-5 text-blue-600 dark:text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 7v10c0 2.21 3.582 4 8 4s8-1.79 8-4V7M4 7c0 2.21 3.582 4 8 4s8-1.79 8-4M4 7c0-2.21 3.582-4 8-4s8 1.79 8 4m0 5c0 2.21-3.582 4-8 4s-8-1.79-8-4"></path>
                    </svg>
                </div>
                <div class="flex-1">
                    <h3 class="text-sm font-semibold text-gray-900 dark:text-white">Storage Usage</h3>
                    <p class="text-xs text-gray-500 dark:text-gray-400">{{ $usedMb }}MB of {{ $quotaMb }}MB used</p>
                </div>
                <div class="text-right">
                    <div class="text-lg font-bold text-gray-900 dark:text-white">{{ number_format($percentUsed, 0) }}%</div>
                    <div class="text-xs text-gray-500 dark:text-gray-400">capacity</div>
                </div>
            </div>

            {{-- Progress Bar --}}
            <div class="w-full bg-gray-200 dark:bg-gray-700 rounded-full h-3 overflow-hidden">
                <div
                    class="h-3 rounded-full transition-all duration-500 ease-out {{ $percentUsed > 90 ? 'bg-red-600' : ($percentUsed > 75 ? 'bg-yellow-600' : 'bg-green-600') }}"
                    style="width: {{ min($percentUsed, 100) }}%"
                ></div>
            </div>

            @if($percentUsed > 90)
                <div class="mt-3 flex items-start gap-2 p-3 bg-red-50 dark:bg-red-900/20 border border-red-200 dark:border-red-800 rounded-lg">
                    <svg class="w-4 h-4 text-red-600 dark:text-red-400 flex-shrink-0 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd"></path>
                    </svg>
                    <div>
                        <p class="text-xs font-semibold text-red-800 dark:text-red-200">Low storage space</p>
                        <p class="text-xs text-red-700 dark:text-red-300 mt-0.5">Please delete some files to free up space.</p>
                    </div>
                </div>
            @elseif($percentUsed > 75)
                <div class="mt-3 flex items-start gap-2 p-3 bg-yellow-50 dark:bg-yellow-900/20 border border-yellow-200 dark:border-yellow-800 rounded-lg">
                    <svg class="w-4 h-4 text-yellow-600 dark:text-yellow-400 flex-shrink-0 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd"></path>
                    </svg>
                    <p class="text-xs text-yellow-800 dark:text-yellow-200">You're approaching your storage limit. Consider deleting old attachments.</p>
                </div>
            @endif
        </div>
    @endif
</div>
