@props([
    'padding' => 'md',
    'variant' => 'default',
])

@php
    $paddingClasses = [
        'none' => 'p-0',
        'xs' => 'p-3',
        'sm' => 'p-4',
        'md' => 'p-6',
        'lg' => 'p-8',
    ];

    $variantClasses = [
        'default' => 'bg-white dark:bg-zinc-900 border border-zinc-200 dark:border-zinc-700 shadow-sm',
        'muted' => 'bg-zinc-50 dark:bg-zinc-900/70 border border-zinc-200 dark:border-zinc-700',
        'ghost' => 'bg-transparent border border-transparent shadow-none',
    ];

    $paddingClass = $paddingClasses[$padding] ?? $paddingClasses['md'];
    $variantClass = $variantClasses[$variant] ?? $variantClasses['default'];
@endphp

<div {{ $attributes->class([$variantClass, $paddingClass, 'rounded-xl transition-shadow duration-200']) }}>
    @isset($header)
        <div class="mb-4">
            {{ $header }}
        </div>
    @endisset

    {{ $slot }}

    @isset($footer)
        <div class="mt-4 pt-4 border-t border-zinc-200 dark:border-zinc-700">
            {{ $footer }}
        </div>
    @endisset
</div>
