@php
    $record = $getRecord();

    // Determine avatar source
    if($record->profile_photo_path) {
        $avatar_src = config('app.url') . '/storage/' . $record->profile_photo_path;
    } else {
        $avatar_src = "https://gravatar.com/avatar/" . hash('sha256', strtolower(trim($record->email))) . ".png?s=256";
    }

    // Determine online status badge color
    $badge_color = $record->is_online > 0 ? 'green' : 'red';
@endphp

<div class="flex items-center justify-center">
    <flux:avatar
        badge
        badge:color="{{ $badge_color }}"
        size="lg"
        src="{{ $avatar_src }}"
    />
</div>
