@props(['href' => '#', 'icon' => null, 'active' => false])

@php
    $classes = 'flex items-center gap-3 px-3 py-2 text-sm rounded-lg transition-colors';
    $classes .= $active
        ? ' bg-indigo-100 dark:bg-indigo-900 text-indigo-700 dark:text-indigo-300'
        : ' text-zinc-700 dark:text-zinc-300 hover:bg-zinc-100 dark:hover:bg-zinc-800';
@endphp

<a href="{{ $href }}" wire:navigate {{ $attributes->merge(['class' => $classes]) }}>
    @if($icon)
        <x-ticaga-icon :name="$icon" class="w-5 h-5 flex-shrink-0" />
    @endif
    <span>{{ $slot }}</span>
</a>
