@props([
    'icon' => null,
    'iconTrailing' => null,
    'size' => 'md',
])

@php
    $sizeClasses = [
        'sm' => 'px-3 py-1.5 text-sm',
        'md' => 'px-4 py-2 text-base',
        'lg' => 'px-5 py-3 text-lg',
    ];

    $classes = 'inline-flex items-center gap-2 font-medium rounded-lg transition-colors focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500';
    $classes .= ' ' . ($sizeClasses[$size] ?? $sizeClasses['md']);
@endphp

<button type="button" {{ $attributes->merge(['class' => $classes]) }}>
    @if($icon)
        <x-ticaga-icon :name="$icon" class="w-4 h-4 flex-shrink-0" />
    @endif

    <span>{{ $slot }}</span>

    @if($iconTrailing)
        <x-ticaga-icon :name="$iconTrailing" class="w-4 h-4 flex-shrink-0" />
    @endif
</button>
