@props([
    'label' => null,
    'name' => null,
    'checked' => false,
])

@php
    $classes = 'w-4 h-4 text-indigo-600 bg-zinc-100 border-zinc-300 rounded focus:ring-indigo-500 focus:ring-2 dark:bg-zinc-700 dark:border-zinc-600 dark:focus:ring-indigo-600 dark:ring-offset-zinc-800 cursor-pointer';
@endphp

<div class="flex items-center gap-2">
    <input
        type="checkbox"
        {{ $attributes->merge(['class' => $classes]) }}
        @if($name) name="{{ $name }}" @endif
        @if($checked) checked @endif
    />
    @if($label)
        <label {{ $attributes->only(['wire:model', 'id'])->merge(['class' => 'text-sm font-medium text-zinc-900 dark:text-zinc-300 cursor-pointer']) }}>
            {{ $label }}
        </label>
    @endif
</div>
