@props(['column', 'sortColumn', 'sortAsc'])
<button wire:click="sortBy('{{ $column }}')" {{ $attributes->merge(['class' => 'flex items-center gap-2 group']) }}>
    {{ $slot }}
    @if($sortColumn === $column)
        <div class="text-gray-400">
            @if($column === 'ticket_id')
                @if($sortAsc)
                    <x-mary-icon name="lucide.arrow-up-1-0" />
                @else
                    <x-mary-icon name="lucide.arrow-down-1-0" />
                @endif
            @else
                @if($sortAsc)
                    <x-mary-icon name="lucide.sort-asc" />
                @else
                    <x-mary-icon name="lucide.sort-desc" />
                @endif
            @endif
        </div>
    @else
        <div class="text-gray-400 opacity-0 group-hover:opacity-100">
            <x-mary-icon name="lucide.list-filter" />
        </div>
    @endif
</button>
