<div class="flex items-center" x-data="selectAll">
    <input type="checkbox" x-ref="checkbox" @change="handleChange"
           class="rounded-sm border-gray-300 shadow-sm">
</div>

@script
<script>
    Alpine.data('selectAll', () => {
        return {
            init() {
                this.$wire.$watch('selectedRows', () => {
                    this.updateCheckRows()
                })

                this.$wire.$watch('allRows', () => {
                    this.updateCheckRows()
                })
            },

            updateCheckRows() {
                if (this.rowisSelected()) {
                    this.$refs.checkbox.checked = true
                    this.$refs.checkbox.indeterminate = false
                } else if (this.rowisEmpty()) {
                    this.$refs.checkbox.checked = false
                    this.$refs.checkbox.indeterminate = false
                } else {
                    this.$refs.checkbox.checked = false
                    this.$refs.checkbox.indeterminate = true
                }
            },

            rowisSelected() {
                return this.$wire.allRows.every(id => this.$wire.selectedRows.includes(id))
            },

            rowisEmpty() {
                return this.$wire.selectedRows.length === 0
            },

            handleChange(e) {
                e.target.checked ? this.selectAll() : this.deselectAll()
            },

            selectAll() {
                this.$wire.selectedRows = this.$wire.allRows
                this.$wire.allRows.forEach(id => {
                    if (this.wire.selectedRows.includes(id)) return

                    this.$wire.selectedRows.push(id)
                })
            },

            deselectAll() {
                this.$wire.selectedRows = []
            },
        }
    })
</script>
@endscript
