<x-layouts.app :title="__('Viewing Announcement')">
    <flux:heading size="xl" level="1">
        {{ $announcement->title }} 
        @hasanyrole('superadmin|admin')
            <button id="dropdownMenuIconHorizontalButton" data-dropdown-toggle="dropdownDotsHorizontal" class="inline-flex items-center p-2 text-sm font-medium text-center text-gray-900 bg-white rounded-lg hover:bg-gray-100 focus:ring-4 focus:outline-none dark:text-white focus:ring-gray-50 dark:bg-gray-900 dark:hover:bg-gray-700 dark:focus:ring-gray-600" type="button"> 
                <svg class="w-5 h-5" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 16 3">
                    <path d="M2 0a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3Zm6.041 0a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3ZM14 0a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3Z"/>
                </svg>
            </button>
            <div id="dropdownDotsHorizontal" class="z-10 hidden bg-white divide-y divide-gray-100 rounded-lg shadow-sm w-44 dark:bg-gray-700 dark:divide-gray-600">
                <ul class="py-2 text-sm text-gray-700 dark:text-gray-200" aria-labelledby="dropdownMenuIconHorizontalButton">
                    <li>
                        <a href="#" data-modal-target="edit-announcement-modal" data-modal-toggle="edit-announcement-modal" class="block hover:bg-gray-100 dark:hover:bg-gray-600 dark:hover:text-white">
                            <flux:menu.item icon="pencil">{{ __("Edit") }}</flux:menu.item>
                        </a>
                    </li>
                    <li>
                        <a href="{{ url()->previous() }}" class="block hover:bg-gray-100 dark:hover:bg-gray-600 dark:hover:text-white">
                            <flux:menu.item icon="corner-up-left">{{ __("Return") }}</flux:menu.item>
                        </a>
                    </li>
                </ul>
            </div>
        @else
            <flux:button icon="corner-up-left" variant="ghost" href="{{ url()->previous() }}"> {{ __('Return') }}</flux:button>
        @endhasanyrole
    </flux:heading>
    <flux:text class="mt-2">
    Posted by {{ $customer->name }} on {{ Carbon\Carbon::parse($announcement->announcement_created)->format('d F Y h:i A') }}
    @hasanyrole('superadmin|admin')
        <span class="text-gray-400 dark:text-gray-500">•</span>
        <span class="inline-flex items-center gap-1">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                <path stroke-linecap="round" stroke-linejoin="round" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                <path stroke-linecap="round" stroke-linejoin="round" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
            </svg>
            {{ number_format($announcement->views) }} {{ $announcement->views == 1 ? __('view') : __('views') }}
        </span>
        <span class="text-gray-400 dark:text-gray-500">•</span>
        <span class="inline-flex items-center gap-1">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                <path stroke-linecap="round" stroke-linejoin="round" d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z" />
            </svg>
            {{ number_format($announcement->likes) }} {{ $announcement->likes == 1 ? __('like') : __('likes') }}
        </span>
    @endhasanyrole
    </flux:text>
    <flux:separator variant="subtle" class="mt-3 mb-3" />
    
    <div class="text-gray-900 dark:text-white py-4 dark:bg-gray-900 whitespace-pre-line">
        {!! Str::of($announcement->content)->inlinemarkdown(['html_input' => 'strip', 'allow_unsafe_links' => false,]) !!}
    </div>

    <div class="mt-4">
        <livewire:announcements.like-button :announcementId="$announcement->announcement_id" />
    </div>

    <div class="mt-6">
        <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-3">About the Author</h3>
        <div class="text-gray-900 dark:text-white bg-white border border-neutral-200 rounded-lg shadow-sm dark:bg-gray-900 dark:border-neutral-700 overflow-hidden transition-shadow hover:shadow-md">
            <div class="flex flex-row items-start p-6 gap-6">
                @php
                    if($customer->profile_photo_path != '') {
                        $avatar_src = config('app.url') . '/storage/' . $customer->profile_photo_path;
                    } else {
                        $avatar_src = "https://gravatar.com/avatar/" . hash('sha256', strtolower(trim($customer->email))) . ".png?s=1024";
                    }

                    if($customer)
                    {
                        $customer_role = $customer->roles->pluck('name')[0];
                    } else {
                        $customer_role = '';
                    }

                    if($customer_role)
                    {
                        if($customer_role == 'superadmin') {
                            $role = "Senior Management";
                            $roleColor = "bg-purple-100 text-purple-800 dark:bg-purple-900 dark:text-purple-300";
                        } elseif($customer_role == 'admin') {
                            $role = "Management";
                            $roleColor = "bg-blue-100 text-blue-800 dark:bg-blue-900 dark:text-blue-300";
                        } elseif($customer_role == 'employee') {
                            $role = "Employee";
                            $roleColor = "bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-300";
                        } elseif($customer_role == 'customer') {
                            $role = "Customer";
                            $roleColor = "bg-yellow-100 text-yellow-800 dark:bg-yellow-900 dark:text-yellow-300";
                        } else {
                            $role = "Guest";
                            $roleColor = "bg-gray-100 text-gray-800 dark:bg-gray-900 dark:text-gray-300";
                        }
                    } else {
                        $role = "Guest";
                        $roleColor = "bg-gray-100 text-gray-800 dark:bg-gray-900 dark:text-gray-300";
                    }

                    $badge_color = ($online_status ?? false) ? 'green' : 'red';
                @endphp

                <div class="flex-shrink-0">
                    <flux:avatar
                        badge
                        badge:color="{{ $badge_color }}"
                        size="xl"
                        src="{{ $avatar_src }}"
                    />
                </div>

                <div class="flex flex-col flex-grow justify-start">
                    <div class="flex items-center gap-3">
                        <h5 class="text-2xl font-bold tracking-tight text-gray-900 dark:text-white">
                            {{ $customer->name }}
                        </h5>
                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium {{ $roleColor }}">
                            {{ $role }}
                        </span>
                    </div>
                    @if($customer->biography)
                        <div class="prose prose-sm dark:prose-invert max-w-none -mt-5">
                            <p class="text-gray-700 dark:text-gray-300 leading-relaxed whitespace-pre-line">
                                {!! Str::of($customer->biography)->inlinemarkdown(['html_input' => 'strip', 'allow_unsafe_links' => false,]) !!}
                            </p>
                        </div>
                    @else
                        <p class="text-gray-500 dark:text-gray-400 italic">No biography available.</p>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <div id="edit-announcement-modal" data-modal-backdrop="static" tabindex="-1" aria-hidden="true" class="hidden overflow-y-auto overflow-x-hidden fixed top-0 right-0 left-0 z-50 justify-center items-center w-full md:inset-0 h-[calc(100%-1rem)] max-h-full">
        <div class="relative p-4 w-full max-w-2xl max-h-full">
            <!-- Modal content -->
            <div class="relative bg-white rounded-lg shadow-sm dark:bg-gray-700">
                <!-- Modal header -->
                <div class="flex items-center justify-between p-4 md:p-5 border-b rounded-t dark:border-gray-600 border-gray-200">
                    <h3 class="text-xl font-semibold text-gray-900 dark:text-white">
                        Edit Announcement
                    </h3>
                    <button type="button" class="end-2.5 text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm w-8 h-8 ms-auto inline-flex justify-center items-center dark:hover:bg-gray-600 dark:hover:text-white" data-modal-hide="edit-announcement-modal">
                        <svg class="w-3 h-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 14 14">
                            <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6"/>
                        </svg>
                        <span class="sr-only">Close modal</span>
                    </button>
                </div>
                <!-- Modal body -->
                <div class="p-4 md:p-5">
                    <livewire:announcements.edit :id="$announcement->announcement_id" :slug="$announcement->slug" />
                </div>
            </div>
        </div>
    </div>
</x-layouts.app>
