module.exports =
/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};

/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {

/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId])
/******/ 			return installedModules[moduleId].exports;

/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			exports: {},
/******/ 			id: moduleId,
/******/ 			loaded: false
/******/ 		};

/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);

/******/ 		// Flag the module as loaded
/******/ 		module.loaded = true;

/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}


/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;

/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;

/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "/build/";

/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(0);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";

	const ReactDOM = __webpack_require__(1);
	const markdownx_ast_1 = __webpack_require__(2);
	const render_1 = __webpack_require__(3);
	var components_1 = __webpack_require__(6);
	exports.defaultComponents = components_1.defaultComponents;
	exports.MarkdownContext = components_1.MarkdownContext;
	exports.contextDef = components_1.contextDef;
	function parseMarkdown(src) {
	    const sections = markdownx_ast_1.parse(src);
	    return {
	        type: "document",
	        children: sections
	    };
	}
	function configureMarkdown(components) {
	    const renderReact = render_1.configureRender(components);
	    function renderReactMarkup(node) {
	        return ReactDOM.renderToString(renderReact(node));
	    }
	    /*
	    * Render markup string without React checksum.
	    */
	    function renderMarkup(node) {
	        return ReactDOM.renderToStaticMarkup(renderReact(node));
	    }
	    return {
	        renderMarkup: renderMarkup,
	        renderReact: renderReact,
	        renderReactMarkup: renderReactMarkup,
	        parse: parseMarkdown
	    };
	}
	exports.configureMarkdown = configureMarkdown;
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.default = configureMarkdown;

/***/ },
/* 1 */
/***/ function(module, exports) {

	module.exports = require("react-dom/server");

/***/ },
/* 2 */
/***/ function(module, exports) {

	module.exports = require("markdownx-ast");

/***/ },
/* 3 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";

	const React = __webpack_require__(4);
	const ast = __webpack_require__(5);
	const components_1 = __webpack_require__(6);
	function configureRender() {
	    let customComponents = arguments.length <= 0 || arguments[0] === undefined ? {} : arguments[0];

	    const components = Object.assign({}, components_1.defaultComponents, customComponents);
	    class RenderContext extends React.Component {
	        getChildContext() {
	            return {
	                renderMarkdown: renderMarkdown,
	                components: components
	            };
	        }

	        render() {
	            return this.props.children;
	        }
	    }
	    RenderContext.childContextTypes = {
	        renderMarkdown: React.PropTypes.func,
	        components: React.PropTypes.object
	    };
	    return render;
	    function render(content) {
	        return React.createElement(RenderContext, null, renderMarkdown(content));
	    }
	    function renderMarkdown(node) {
	        if (typeof node === "string") {
	            return node;
	        } else if (node.constructor === Array) {
	            return renderChildren(node);
	        } else {
	            const type = node.type;
	            const Component = findComponent(type);
	            return React.createElement(Component, React.__spread({}, node));
	        }
	    }
	    function renderChildren(children) {
	        let i = 0;
	        let unique = makeEnsureUnique();
	        return children.map(node => {
	            let key;
	            if (typeof node === "string") {
	                return node;
	            } else {
	                const Component = findComponent(node.type);
	                if (ast.isIdNode(node)) {
	                    key = unique(node.id);
	                } else {
	                    key = unique(i.toString());
	                }
	                return React.createElement(Component, React.__spread({ key: key }, node));
	            }
	        });
	    }
	    function findComponent(type) {
	        return components[type] || components["unknown"];
	    }
	}
	exports.configureRender = configureRender;
	function makeEnsureUnique() {
	    let ids = {};
	    return function ensureUnique(str) {
	        let id = str;
	        let i = 1;
	        while (true) {
	            let tryId = id;
	            if (i != 1) {
	                tryId = tryId + "_" + i;
	            }
	            if (ids[tryId] == null) {
	                id = tryId;
	                ids[id] = true;
	                break;
	            }
	            i++;
	        }
	        return id;
	    };
	}
	exports.makeEnsureUnique = makeEnsureUnique;

/***/ },
/* 4 */
/***/ function(module, exports) {

	module.exports = require("react");

/***/ },
/* 5 */
/***/ function(module, exports) {

	module.exports = require("markdownx-ast/ast");

/***/ },
/* 6 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";

	const React = __webpack_require__(4);
	exports.contextDef = {
	    contextTypes: {
	        renderMarkdown: React.PropTypes.func,
	        components: React.PropTypes.object
	    }
	};
	const Unknown_1 = __webpack_require__(7);
	const Document_1 = __webpack_require__(8);
	const Section_1 = __webpack_require__(9);
	// blocks
	const Heading_1 = __webpack_require__(10);
	const Paragraph_1 = __webpack_require__(11);
	const List_1 = __webpack_require__(12);
	const Code_1 = __webpack_require__(13);
	const BlockQuote_1 = __webpack_require__(14);
	// html
	const JSX_1 = __webpack_require__(15);
	const HTML_1 = __webpack_require__(16);
	// inline
	const Newline_1 = __webpack_require__(17);
	const Link_1 = __webpack_require__(18);
	const Image_1 = __webpack_require__(19);
	const Strong_1 = __webpack_require__(20);
	const InlineCode_1 = __webpack_require__(21);
	const Emphasis_1 = __webpack_require__(22);
	exports.defaultComponents = {
	    document: Document_1.Document,
	    section: Section_1.Section,
	    paragraph: Paragraph_1.Paragraph,
	    heading: Heading_1.Heading,
	    list: List_1.List,
	    "list-item": List_1.ListItem,
	    jsx: JSX_1.JSX,
	    html: HTML_1.HTML,
	    unknown: Unknown_1.Unknown,
	    code: Code_1.Code,
	    newline: Newline_1.Newline,
	    link: Link_1.Link,
	    image: Image_1.Image,
	    strong: Strong_1.Strong,
	    "inline-code": InlineCode_1.InlineCode,
	    emphasis: Emphasis_1.Emphasis,
	    blockquote: BlockQuote_1.BlockQuote
	};

/***/ },
/* 7 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";

	const React = __webpack_require__(4);
	function Unknown(node) {
	    return React.createElement("span", null, "Unknown component: ", node.type);
	}
	exports.Unknown = Unknown;
	;

/***/ },
/* 8 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";

	const React = __webpack_require__(4);
	const index_1 = __webpack_require__(6);
	function Document(node, _ref) {
	    let renderMarkdown = _ref.renderMarkdown;
	    const children = node.children;

	    return React.createElement("article", { className: "markdown" }, renderMarkdown(children));
	}
	exports.Document = Document;
	;
	Object.assign(Document, index_1.contextDef);

/***/ },
/* 9 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";

	const React = __webpack_require__(4);
	const index_1 = __webpack_require__(6);
	function Section(props, _ref) {
	    let renderMarkdown = _ref.renderMarkdown;
	    let id = props.id;
	    let children = props.children;

	    return React.createElement("section", { id: id }, renderMarkdown(children));
	}
	exports.Section = Section;
	Object.assign(Section, index_1.contextDef);

/***/ },
/* 10 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";

	const React = __webpack_require__(4);
	const headerLevels = ["h1", "h2", "h3", "h4", "h5", "h6"];
	function Heading(props) {
	    let depth = props.depth;
	    let text = props.text;
	    let id = props.id;

	    let tag = headerLevels[depth - 1];
	    let headerProps = id ? { id: id } : {};
	    let body = React.createElement("a", { href: "#" + id }, text);
	    return React.createElement(tag, headerProps, body);
	}
	exports.Heading = Heading;

/***/ },
/* 11 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";

	const React = __webpack_require__(4);
	const index_1 = __webpack_require__(6);
	function Paragraph(node, _ref) {
	    let renderMarkdown = _ref.renderMarkdown;
	    const children = node.children;

	    return React.createElement("p", null, renderMarkdown(children));
	}
	exports.Paragraph = Paragraph;
	Object.assign(Paragraph, index_1.contextDef);

/***/ },
/* 12 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";

	const React = __webpack_require__(4);
	const index_1 = __webpack_require__(6);
	function List(node, _ref) {
	    let renderMarkdown = _ref.renderMarkdown;
	    const items = node.items;
	    const ordered = node.ordered;

	    const tag = ordered ? "ol" : "ul";
	    const renderedItems = renderMarkdown(items);
	    return React.createElement(tag, null, renderedItems);
	}
	exports.List = List;
	Object.assign(List, index_1.contextDef);
	function ListItem(node, _ref2) {
	    let renderMarkdown = _ref2.renderMarkdown;
	    const children = node.children;

	    let content = renderMarkdown(children);
	    // if(node.isBlock) {
	    //   content = <div>{content}</div>;
	    // }
	    return React.createElement("li", null, content);
	}
	exports.ListItem = ListItem;
	Object.assign(ListItem, index_1.contextDef);

/***/ },
/* 13 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";

	const React = __webpack_require__(4);
	function Code(node) {
	    const text = node.text;
	    const lang = node.lang;

	    return React.createElement("pre", null, React.createElement("code", { className: lang }, text));
	}
	exports.Code = Code;

/***/ },
/* 14 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";

	const React = __webpack_require__(4);
	const index_1 = __webpack_require__(6);
	function BlockQuote(node, _ref) {
	    let renderMarkdown = _ref.renderMarkdown;
	    const children = node.children;

	    return React.createElement("blockquote", null, renderMarkdown(children));
	}
	exports.BlockQuote = BlockQuote;
	Object.assign(BlockQuote, index_1.contextDef);

/***/ },
/* 15 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";

	const React = __webpack_require__(4);
	const index_1 = __webpack_require__(6);
	function JSX(node, _ref) {
	    let components = _ref.components;
	    let renderMarkdown = _ref.renderMarkdown;
	    const name = node.name;
	    const attrs = node.attrs;
	    const sections = node.sections;

	    const Component = components[name];
	    if (Component === undefined) {
	        return React.createElement("span", null, "Unknown component: ", name);
	    }
	    const props = {
	        content: {
	            sections: sections,
	            renderMarkdown: renderMarkdown
	        }
	    };
	    return React.createElement(Component, React.__spread({}, props, attrs));
	}
	exports.JSX = JSX;
	Object.assign(JSX, index_1.contextDef);

/***/ },
/* 16 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";

	const React = __webpack_require__(4);
	function HTML(node) {
	    const text = node.text;
	    const inline = node.inline;

	    const tagName = inline ? "span" : "div";
	    return React.createElement(tagName, { dangerouslySetInnerHTML: { __html: text } });
	}
	exports.HTML = HTML;

/***/ },
/* 17 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";

	const React = __webpack_require__(4);
	function Newline(node) {
	    return React.createElement("br", null);
	}
	exports.Newline = Newline;

/***/ },
/* 18 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";

	const React = __webpack_require__(4);
	function Link(node) {
	    const href = node.href;
	    const caption = node.caption;

	    return React.createElement("a", { href: href }, caption);
	}
	exports.Link = Link;

/***/ },
/* 19 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";

	const React = __webpack_require__(4);
	function Image(node) {
	    const href = node.href;
	    const caption = node.caption;

	    return React.createElement("img", { src: href, alt: caption });
	}
	exports.Image = Image;

/***/ },
/* 20 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";

	const React = __webpack_require__(4);
	function Strong(node) {
	    const text = node.text;

	    return React.createElement("strong", null, text);
	}
	exports.Strong = Strong;

/***/ },
/* 21 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";

	const React = __webpack_require__(4);
	function InlineCode(node) {
	    const text = node.text;

	    return React.createElement("code", null, text);
	}
	exports.InlineCode = InlineCode;

/***/ },
/* 22 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";

	const React = __webpack_require__(4);
	function Emphasis(node) {
	    const text = node.text;

	    return React.createElement("em", null, text);
	}
	exports.Emphasis = Emphasis;

/***/ }
/******/ ]);