module.exports =
/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};

/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {

/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId])
/******/ 			return installedModules[moduleId].exports;

/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			exports: {},
/******/ 			id: moduleId,
/******/ 			loaded: false
/******/ 		};

/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);

/******/ 		// Flag the module as loaded
/******/ 		module.loaded = true;

/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}


/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;

/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;

/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "/build/";

/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(0);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";

	function __export(m) {
	    for (var p in m) {
	        if (!exports.hasOwnProperty(p)) exports[p] = m[p];
	    }
	}
	var walk_1 = __webpack_require__(1);
	exports.walk = walk_1.walk;
	__export(__webpack_require__(2));
	__export(__webpack_require__(3));

/***/ },
/* 1 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";

	var ast = __webpack_require__(2);
	// depth first walk
	function walk(node, fn) {
	    if (ast.isContentNode(node)) {
	        fn(node);
	        node.children.forEach(function (child) {
	            walk(child, fn);
	        });
	    } else {
	        fn(node);
	    }
	}
	exports.walk = walk;

/***/ },
/* 2 */
/***/ function(module, exports) {

	// Abstract Sytnax Tree for Markdown Document
	"use strict";

	exports.NodeTypes = {
	    document: "document",
	    heading: "heading",
	    section: "section",
	    list: "list",
	    list_item: "list-item",
	    paragraph: "paragraph",
	    code: "code",
	    html: "html",
	    jsx: "jsx",
	    i18n: "i18n",
	    blockquote: "blockquote",
	    newline: "newline"
	};
	function isContentNode(o) {
	    return o.children != null;
	}
	exports.isContentNode = isContentNode;
	function isIdNode(o) {
	    return o.id != null;
	}
	exports.isIdNode = isIdNode;
	function isTextNode(o) {
	    return o.text != null;
	}
	exports.isTextNode = isTextNode;
	;
	function isHeading(o) {
	    return o.type === exports.NodeTypes.heading;
	}
	exports.isHeading = isHeading;
	function isListItem(o) {
	    return o.type == exports.NodeTypes.list_item;
	}
	exports.isListItem = isListItem;
	function isList(o) {
	    return o.type == exports.NodeTypes.list;
	}
	exports.isList = isList;

/***/ },
/* 3 */
/***/ function(module, exports, __webpack_require__) {

	// let sectionize = require("./sectionize");
	"use strict";

	var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

	function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

	var _require = __webpack_require__(4);

	var lexer = _require.lexer;

	var _require2 = __webpack_require__(5);

	var makeEnsureUnique = _require2.makeEnsureUnique;

	var ast = __webpack_require__(2);
	var tk = __webpack_require__(7);
	var inline_1 = __webpack_require__(8);
	var NodeTypes = ast.NodeTypes;

	var parseXMLHeredoc_1 = __webpack_require__(9);
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.default = parse;
	function parse(src) {
	    var tokens = tokenize(src);
	    var sections = _parse(tokens);
	    return sections;
	}
	exports.parse = parse;
	function tokenize(src) {
	    return lexer(src);
	}
	exports.tokenize = tokenize;
	function _parse(tokens) {
	    var sections = [];
	    var ensureUnique = makeEnsureUnique();
	    // dup tokens
	    tokens = tokens.reverse();
	    function popToken() {
	        return tokens.pop();
	    }
	    function peekToken() {
	        if (tokens.length == 0) {
	            return null;
	        }
	        return tokens[tokens.length - 1];
	    }
	    function parseListItem() {
	        var start = popToken();
	        var children = undefined;
	        var looseItem = false;
	        if (start.type === tk.Types.loose_item_start) {
	            looseItem = true;
	            // Kludgy handling of "loose items". The tokens returned by the lexer are messy to begin with.
	            children = parseContent(tk.Types.list_item_end, [], true).map(function (node) {
	                if (typeof node === "string") {
	                    // Add space to prevent text strings from being joined together.
	                    return node + " ";
	                } else {
	                    if (node.type === "space") {
	                        var newline = {
	                            type: "newline"
	                        };
	                        return newline;
	                    } else {
	                        return node;
	                    }
	                }
	            });
	        } else {
	            children = parseContent(tk.Types.list_item_end);
	        }
	        popToken(); // list_item_end
	        return {
	            type: NodeTypes.list_item,
	            children: children,
	            isBlock: looseItem
	        };
	    }
	    function parseList() {
	        // "list_start"

	        var _popToken = popToken();

	        var ordered = _popToken.ordered;

	        var items = [];
	        while (tokens.length > 0) {
	            var token = peekToken();
	            var type = token.type;

	            if (type === tk.Types.list_end) {
	                popToken();
	                break;
	            } else if (tk.isListItemStartToken(token)) {
	                items.push(parseListItem());
	            }
	        }
	        return { type: NodeTypes.list, ordered: ordered, items: items };
	    }
	    function parseBlockQuote() {
	        popToken(); // blockquote_start
	        var children = parseContent(tk.Types.blockquote_end);
	        popToken(); // blockquote_end
	        return {
	            type: "blockquote",
	            children: children
	        };
	    }
	    function parseSection() {
	        var token = peekToken();
	        var id = undefined;
	        var heading = undefined;
	        var content = [];
	        if (token.type === tk.Types.heading) {
	            var headingToken = token;
	            heading = parseHeading();
	            id = heading.id;
	            content.push(heading);
	        } else {
	            id = "_top";
	        }
	        parseContent(ast.NodeTypes.heading, content);
	        return {
	            type: NodeTypes.section,
	            children: content,
	            id: id
	        };
	    }
	    function parseHeading() {
	        var token = tokens.pop();
	        var id = ensureUnique(token.text);
	        return {
	            id: id,
	            type: ast.NodeTypes.heading,
	            depth: token.depth,
	            text: token.text
	        };
	    }
	    function parseParagraph() {
	        var token = tokens.pop();
	        return {
	            type: "paragraph",
	            children: inline_1.parseInline(token.text)
	        };
	    }
	    // Treat uppercase HTML tags as components. Parse text content recursively.
	    function parseComponent() {
	        var _tokens$pop = tokens.pop();

	        var text = _tokens$pop.text;

	        var _parseXMLHeredoc_1$pa = parseXMLHeredoc_1.parseXMLHeredoc(text);

	        var _parseXMLHeredoc_1$pa2 = _slicedToArray(_parseXMLHeredoc_1$pa, 2);

	        var doc = _parseXMLHeredoc_1$pa2[0];
	        var _ = _parseXMLHeredoc_1$pa2[1];
	        var tag = doc.tag;
	        var attrs = doc.attrs;
	        var content = doc.content;

	        var node = {
	            type: "jsx",
	            name: tag,
	            attrs: attrs
	        };
	        if (content) {
	            node.sections = parse(content);
	        }
	        return node;
	    }
	    function parseContent(endType) {
	        var content = arguments.length <= 1 || arguments[1] === undefined ? [] : arguments[1];
	        var preserveSpace = arguments.length <= 2 || arguments[2] === undefined ? false : arguments[2];

	        // let content: Node[] = [];
	        while (true) {
	            var token = peekToken();
	            if (token == null) {
	                return content;
	            }
	            if (token.type == endType) {
	                return content;
	            }
	            // Get rid of space, except when it matters (list items...)
	            if (token.type === "space" && !preserveSpace) {
	                tokens.pop();
	                continue;
	            }
	            if (tk.isListStartToken(token)) {
	                content.push(parseList());
	            } else if (tk.isText(token)) {
	                tokens.pop();
	                var children = inline_1.parseInline(token.text);
	                content.push.apply(content, _toConsumableArray(children));
	            } else if (token.type === tk.Types.paragraph) {
	                content.push(parseParagraph());
	            } else if (token.type === tk.Types.heading) {
	                content.push(parseHeading());
	            } else if (token.type === tk.Types.blockquote_start) {
	                content.push(parseBlockQuote());
	            } else if (token.type === tk.Types.html) {
	                var text = token.text;

	                if (text.match(/^<[A-Z]/)) {
	                    // treat uppercase tags as components
	                    content.push(parseComponent());
	                } else {
	                    // normal html node
	                    var _tk = tokens.pop();
	                    var node = {
	                        type: 'html',
	                        inline: false,
	                        pre: true,
	                        text: _tk.text
	                    };
	                    content.push(node);
	                }
	            } else {
	                content.push(tokens.pop());
	            }
	        }
	    }
	    while (tokens.length > 0) {
	        sections.push(parseSection());
	    }
	    // createSection();
	    return sections;
	}

/***/ },
/* 4 */
/***/ function(module, exports) {

	module.exports = require("marked");

/***/ },
/* 5 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	// let {kebabCase} = require("lodash");

	var lodash_1 = __webpack_require__(6);
	function makeEnsureUnique() {
	    var ids = {};
	    return function ensureUnique(str) {
	        var id = lodash_1.kebabCase(str);
	        var i = 1;
	        while (true) {
	            var tryId = id;
	            if (i != 1) {
	                tryId = tryId + "_" + i;
	            }
	            if (ids[tryId] == null) {
	                id = tryId;
	                ids[id] = true;
	                break;
	            }
	            i++;
	        }
	        return id;
	    };
	}
	exports.makeEnsureUnique = makeEnsureUnique;
	function pp(obj) {
	    console.log(JSON.stringify(obj, undefined, 2));
	    return obj;
	}
	exports.pp = pp;
	function hashCode(str) {
	    if (str == null || str.charCodeAt == null) {
	        return 0;
	    }
	    var hash = 0,
	        i,
	        chr,
	        len;
	    if (str.length == 0) return hash;
	    for (i = 0, len = str.length; i < len; i++) {
	        chr = str.charCodeAt(i);
	        hash = (hash << 5) - hash + chr;
	        hash |= 0; // Convert to 32bit integer
	    }
	    return hash;
	}
	exports.hashCode = hashCode;
	;

/***/ },
/* 6 */
/***/ function(module, exports) {

	module.exports = require("lodash");

/***/ },
/* 7 */
/***/ function(module, exports) {

	// The objects returned by marked lexer.
	"use strict";

	exports.Types = {
	    heading: "heading",
	    list_start: "list_start",
	    list_end: "list_end",
	    paragraph: "paragraph",
	    list_item_start: "list_item_start",
	    loose_item_start: "loose_item_start",
	    list_item_end: "list_item_end",
	    blockquote_start: "blockquote_start",
	    blockquote_end: "blockquote_end",
	    html: "html",
	    text: "text"
	};
	function isText(t) {
	    return t.type === exports.Types.text;
	}
	exports.isText = isText;
	function isListStartToken(token) {
	    return token.type == exports.Types.list_start;
	}
	exports.isListStartToken = isListStartToken;
	function isListItemStartToken(token) {
	    return token.type == exports.Types.list_item_start || token.type == exports.Types.loose_item_start;
	}
	exports.isListItemStartToken = isListItemStartToken;

/***/ },
/* 8 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";

	var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

	var marked = __webpack_require__(4);
	var options = Object.assign(marked.defaults, { xhtml: true });
	var inlineLexer = new marked.InlineLexer([], options);
	var parseXMLHeredoc_1 = __webpack_require__(9);
	var parser_1 = __webpack_require__(3);
	inlineLexer.outputAST = outputAST;
	function parseInline(src) {
	    return inlineLexer.outputAST(src);
	}
	exports.parseInline = parseInline;
	function outputAST(src) {
	    var items = [];
	    var out = '';
	    var link, text, href, cap;
	    function pushTextItem() {
	        items.push(out);
	        out = "";
	    }
	    function pushNode(node) {
	        pushTextItem();
	        items.push(node);
	    }
	    while (src) {
	        // escape
	        if (cap = this.rules.escape.exec(src)) {
	            src = src.substring(cap[0].length);
	            out += cap[1];
	            continue;
	        }
	        // autolink
	        // if (cap = this.rules.autolink.exec(src)) {
	        //   src = src.substring(cap[0].length);
	        //   if (cap[2] === '@') {
	        //     text = cap[1].charAt(6) === ':'
	        //       ? this.mangle(cap[1].substring(7))
	        //       : this.mangle(cap[1]);
	        //     href = this.mangle('mailto:') + text;
	        //   } else {
	        //     text = escape(cap[1]);
	        //     href = text;
	        //   }
	        //   out += this.renderer.link(href, null, text);
	        //   continue;
	        // }
	        // // url (gfm)
	        // if (!this.inLink && (cap = this.rules.url.exec(src))) {
	        //   src = src.substring(cap[0].length);
	        //   text = escape(cap[1]);
	        //   href = text;
	        //   out += this.renderer.link(href, null, text);
	        //   continue;
	        // }
	        // // tag
	        // if (cap = this.rules.tag.exec(src)) {
	        //   if (!this.inLink && /^<a /i.test(cap[0])) {
	        //     this.inLink = true;
	        //   } else if (this.inLink && /^<\/a>/i.test(cap[0])) {
	        //     this.inLink = false;
	        //   }
	        //   src = src.substring(cap[0].length);
	        //   out += this.options.sanitize
	        //     ? this.options.sanitizer
	        //       ? this.options.sanitizer(cap[0])
	        //       : escape(cap[0])
	        //     : cap[0]
	        //   continue;
	        // }
	        if (cap = this.rules.tag.exec(src)) {
	            var _parseXMLHeredoc_1$pa = parseXMLHeredoc_1.parseXMLHeredoc(src);

	            var _parseXMLHeredoc_1$pa2 = _slicedToArray(_parseXMLHeredoc_1$pa, 2);

	            var result = _parseXMLHeredoc_1$pa2[0];
	            var remainder = _parseXMLHeredoc_1$pa2[1];

	            src = remainder;
	            var firstLetter = result.tag.charAt(0);
	            var isTagFirstLetterUppercase = firstLetter.toUpperCase() == firstLetter;
	            if (!isTagFirstLetterUppercase) {
	                var node = {
	                    inline: true,
	                    type: "html",
	                    pre: false,
	                    text: result.raw
	                };
	                pushNode(node);
	            } else {
	                var tag = result.tag;
	                var attrs = result.attrs;
	                var content = result.content;

	                var node = {
	                    type: "jsx",
	                    name: tag,
	                    attrs: attrs,
	                    sections: content && parser_1.parse(content)
	                };
	                pushNode(node);
	            }
	            continue;
	        }
	        // // link
	        // if (cap = this.rules.link.exec(src)) {
	        //   src = src.substring(cap[0].length);
	        //   this.inLink = true;
	        //   out += this.outputLink(cap, {
	        //     href: cap[2],
	        //     title: cap[3]
	        //   });
	        //   this.inLink = false;
	        //   continue;
	        // }
	        // link
	        if (cap = this.rules.link.exec(src)) {
	            src = src.substring(cap[0].length);
	            var _cap = cap;

	            var _cap2 = _slicedToArray(_cap, 4);

	            var _ = _cap2[0];
	            var caption = _cap2[1];
	            var _href = _cap2[2];
	            var title = _cap2[3];

	            if (cap[0].charAt(0) === "!") {
	                var node = {
	                    type: "image",
	                    caption: caption,
	                    href: _href
	                };
	                if (title) {
	                    node.title = title;
	                }
	                pushNode(node);
	            } else {
	                var node = {
	                    type: "link",
	                    caption: caption,
	                    href: _href
	                };
	                if (title) {
	                    node.title = title;
	                }
	                pushNode(node);
	            }
	            continue;
	        }
	        // // reflink, nolink
	        // if ((cap = this.rules.reflink.exec(src))
	        //     || (cap = this.rules.nolink.exec(src))) {
	        //   src = src.substring(cap[0].length);
	        //   link = (cap[2] || cap[1]).replace(/\s+/g, ' ');
	        //   link = this.links[link.toLowerCase()];
	        //   if (!link || !link.href) {
	        //     out += cap[0].charAt(0);
	        //     src = cap[0].substring(1) + src;
	        //     continue;
	        //   }
	        //   this.inLink = true;
	        //   out += this.outputLink(cap, link);
	        //   this.inLink = false;
	        //   continue;
	        // }
	        // // strong
	        // if (cap = this.rules.strong.exec(src)) {
	        //   src = src.substring(cap[0].length);
	        //   out += this.renderer.strong(this.output(cap[2] || cap[1]));
	        //   continue;
	        // }
	        // strong
	        if (cap = this.rules.strong.exec(src)) {
	            src = src.substring(cap[0].length);
	            var node = {
	                type: "strong",
	                text: cap[2] || cap[1]
	            };
	            pushNode(node);
	            continue;
	        }
	        // // em
	        // if (cap = this.rules.em.exec(src)) {
	        //   src = src.substring(cap[0].length);
	        //   out += this.renderer.em(this.output(cap[2] || cap[1]));
	        //   continue;
	        // }
	        if (cap = this.rules.em.exec(src)) {
	            src = src.substring(cap[0].length);
	            var node = {
	                type: "emphasis",
	                text: cap[2] || cap[1]
	            };
	            pushNode(node);
	            continue;
	        }
	        // code
	        // if (cap = this.rules.code.exec(src)) {
	        //   src = src.substring(cap[0].length);
	        //   out += this.renderer.codespan(escape(cap[2], true));
	        //   continue;
	        // }
	        // code
	        if (cap = this.rules.code.exec(src)) {
	            src = src.substring(cap[0].length);
	            var node = {
	                type: "inline-code",
	                text: cap[2]
	            };
	            pushNode(node);
	            continue;
	        }
	        // // br
	        // if (cap = this.rules.br.exec(src)) {
	        //   src = src.substring(cap[0].length);
	        //   out += this.renderer.br();
	        //   continue;
	        // }
	        // // del (gfm)
	        // if (cap = this.rules.del.exec(src)) {
	        //   src = src.substring(cap[0].length);
	        //   out += this.renderer.del(this.output(cap[1]));
	        //   continue;
	        // }
	        // Accmulate into string.
	        if (cap = this.rules.text.exec(src)) {
	            src = src.substring(cap[0].length);
	            // out += this.renderer.text(escape(this.smartypants(cap[0])));
	            out += cap[0];
	            continue;
	        }
	        if (src) {
	            throw new Error('Infinite loop on byte: ' + src.charCodeAt(0));
	        }
	    }
	    if (out != "") {
	        pushTextItem();
	    }
	    return items;
	    // return out;
	}
	;
	function escape(html, encode) {
	    return html.replace(!encode ? /&(?!#?\w+;)/g : /&/g, '&amp;').replace(/</g, '&lt;').replace(/>/g, '&gt;').replace(/"/g, '&quot;').replace(/'/g, '&#39;');
	}

/***/ },
/* 9 */
/***/ function(module, exports) {

	// Adapted from http://erik.eae.net/simplehtmlparser/simplehtmlparser.js
	// Also see: http://ejohn.org/blog/pure-javascript-html-parser/
	"use strict";

	exports.startTagRE = /^<([-A-Za-z0-9_]+)((?:\s+\w+(?:\s*=\s*(?:(?:"[^"]*")|(?:'[^']*')|[^>\s]+))?)*)\s*(\/?)>/;
	var endTagRE = /^<\/([-A-Za-z0-9_]+)[^>]*>/;
	var attrRE = /([-A-Za-z0-9_]+)(?:\s*=\s*(?:(?:"((?:\\.|[^"])*)")|(?:'((?:\\.|[^'])*)')|([^>\s]+)))?/g;
	function parseXMLHeredoc(input) {
	    var raw = undefined;
	    var remainder = "";
	    var matches = input.match(exports.startTagRE);
	    if (!matches) {
	        return;
	    }
	    raw = matches[0];
	    // console.log(matches);
	    var tagName = matches[1];
	    var tagAttributesString = matches[2] || "";
	    var isSelfClosing = matches[3] === '/';
	    var content = undefined;
	    if (!isSelfClosing) {
	        var closeTag = "</" + tagName + ">";
	        var end = input.lastIndexOf(closeTag);
	        content = input.slice(matches[0].length, end);
	        raw += content + closeTag;
	        remainder = input.substring(end + closeTag.length);
	    } else {
	        remainder = input.substring(matches[0].length);
	    }
	    var attrs = parseAttributes(tagAttributesString);
	    var xml = {
	        tag: tagName,
	        attrs: attrs,
	        content: content,
	        raw: raw
	    };
	    return [xml, remainder];
	}
	exports.parseXMLHeredoc = parseXMLHeredoc;
	function parseAttributes(input) {
	    var attrs = {};
	    input.replace(attrRE, function (a0, a1, a2, a3) {
	        var key = a1;
	        var value = a2 || a3 || true;
	        attrs[key] = value;
	        return "";
	    });
	    return attrs;
	}

/***/ }
/******/ ]);