# Filament Forms Hotfix - Select Component

## Issue
**Error**: `Undefined variable $inlineLabelVerticalAlignment`

**Description**: Filament 4.1.8 has a bug in the `Select` component where it fails to pass the required `:inline-label-vertical-alignment` prop to the `field-wrapper` component. This causes an error when rendering Select fields in forms.

## Affected File
`vendor/filament/forms/resources/views/components/select.blade.php`

## Fix Applied
Added the missing `:inline-label-vertical-alignment` prop to the `<x-dynamic-component>` call on line 33:

```blade
<x-dynamic-component
    :component="$fieldWrapperView"
    :field="$field"
    :inline-label-vertical-alignment="\Filament\Support\Enums\VerticalAlignment::Center"
    class="fi-fo-select-wrp"
>
```

## How to Apply This Hotfix

### Method 1: Manual Copy (Quick)
```bash
cp hot_fix/vendor/filament/forms/resources/views/components/select.blade.php \
   vendor/filament/forms/resources/views/components/select.blade.php
php artisan view:clear
php artisan optimize:clear
```

### Method 2: Automated via install.sh
The `install.sh` script includes a function `apply_hotfixes()` that automatically applies this fix during installation.

### Method 3: Composer Patches (Permanent)
For a more permanent solution that survives `composer update`:

1. Install composer patches plugin:
```bash
composer require cweagans/composer-patches
```

2. Create patch file:
```bash
diff -u vendor/filament/forms/resources/views/components/select.blade.php.bak \
        vendor/filament/forms/resources/views/components/select.blade.php \
        > patches/filament-select-inline-label.patch
```

3. Add to `composer.json`:
```json
"extra": {
    "patches": {
        "filament/forms": {
            "Fix missing inline-label-vertical-alignment in Select component": "patches/filament-select-inline-label.patch"
        }
    }
}
```

## When to Reapply
- After running `composer update filament/forms`
- After upgrading to a new Filament version (check if bug is fixed first)
- After fresh installation from backup

## Check if Fix is Applied
```bash
grep -n "inline-label-vertical-alignment" vendor/filament/forms/resources/views/components/select.blade.php
```

Expected output should show line 33 with the prop.

## Upstream Status
- **Filament Version**: 4.1.8 (released 2025-10-14)
- **Bug Status**: Not yet reported upstream
- **GitHub Issue**: [Create issue if needed](https://github.com/filamentphp/filament/issues)

## Related Files
- `app/Livewire/Clients/Overview.php` - Also updated with `->inlineLabel(false)` on all form fields
- `vendor/filament/forms/resources/views/components/text-input.blade.php` - Already has correct implementation
- `vendor/filament/forms/resources/views/components/field-wrapper.blade.php` - Expects this prop with default value

## Testing
After applying the hotfix, test by:
1. Navigate to `/clients`
2. Click "Create Customer" button
3. Modal should open without errors
4. All form fields (including Select dropdowns) should render correctly

## Notes
- This is a vendor file modification and will be overwritten by composer updates
- Always keep a backup in `hot_fix/` directory
- Consider contributing this fix back to Filament upstream
- The `TextInput` component already has this fix, so only `Select` needed patching

## Date Applied
2025-11-30

## Applied By
Claude AI Assistant

## Verified Working
✅ Tested on Ticaga installation at installer.ticaga.com