<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            // Per-user storage tracking and quotas
            $table->unsignedBigInteger('storage_quota_mb')->nullable()->after('email_verified_at'); // Custom quota override
            $table->unsignedBigInteger('storage_used_bytes')->default(0)->after('storage_quota_mb'); // Current usage

            // Index for quota checks
            $table->index('storage_used_bytes');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropIndex(['storage_used_bytes']);
            $table->dropColumn([
                'storage_quota_mb',
                'storage_used_bytes',
            ]);
        });
    }
};
