<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('attachments', function (Blueprint $table) {
            $table->id();

            // Relationships
            $table->foreignId('ticket_id')->constrained('tickets')->cascadeOnDelete();
            $table->foreignId('response_id')->nullable()->constrained('responses')->cascadeOnDelete();
            $table->foreignId('user_id')->constrained('users')->cascadeOnDelete();

            // File information
            $table->string('filename'); // Hashed filename for storage
            $table->string('original_filename'); // User's original filename
            $table->string('mime_type', 100);
            $table->unsignedBigInteger('size'); // File size in bytes
            $table->string('storage_path'); // Full path in storage
            $table->string('storage_disk', 50)->default('local'); // Storage driver (local, s3, public)

            // Security and scanning
            $table->boolean('virus_scanned')->default(false);
            $table->boolean('virus_detected')->default(false);
            $table->string('virus_scan_result')->nullable();

            // Metadata
            $table->boolean('is_inline')->default(false); // Inline images in email
            $table->boolean('is_from_email')->default(false); // Came from email ingestion
            $table->string('thumbnail_path')->nullable(); // For image previews
            $table->unsignedInteger('download_count')->default(0);

            // Indexing for performance
            $table->index('ticket_id');
            $table->index('response_id');
            $table->index('user_id');
            $table->index(['virus_scanned', 'virus_detected']);

            $table->timestamps();
            $table->softDeletes(); // For retention policies
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('attachments');
    }
};
