<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('mail_accounts', function (Blueprint $table) {
            $table->id();
            $table->string('name'); // Friendly name for the account
            $table->string('email'); // Email address for this account

            // IMAP Configuration
            $table->string('imap_host')->nullable();
            $table->integer('imap_port')->default(993)->nullable();
            $table->string('imap_encryption')->default('ssl')->nullable(); // ssl, tls, or null
            $table->boolean('imap_validate_cert')->default(true)->nullable();
            $table->string('imap_username')->nullable();
            $table->string('imap_password')->nullable();
            $table->string('imap_protocol')->default('imap')->nullable(); // imap, pop3

            // SMTP Configuration
            $table->string('smtp_host')->nullable();
            $table->integer('smtp_port')->default(587)->nullable();
            $table->string('smtp_encryption')->nullable(); // ssl, tls, or null
            $table->string('smtp_username')->nullable();
            $table->string('smtp_password')->nullable();

            // Settings
            $table->boolean('is_active')->default(true);
            $table->boolean('is_default')->default(false);
            $table->string('from_name')->nullable(); // Display name for outgoing emails

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('mail_accounts');
    }
};
