<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('announcement_views', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('announcement_id');
            $table->unsignedBigInteger('user_id')->nullable(); // Nullable for guest users
            $table->string('session_id')->nullable(); // For guest tracking
            $table->timestamp('viewed_at')->useCurrent();

            // Foreign key constraints
            $table->foreign('announcement_id')->references('id')->on('announcements')->onDelete('cascade');
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');

            // Ensure a user/session can only be counted once per announcement
            // For authenticated users: unique by announcement_id + user_id
            // For guests: unique by announcement_id + session_id
            $table->index(['announcement_id', 'user_id']);
            $table->index(['announcement_id', 'session_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('announcement_views');
    }
};
