<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tickets', function (Blueprint $table) {
            $table->id();
            $table->integer('user_id')->default('0');
            $table->string('subject');
            $table->longText('message');
            $table->string('status')->default('open');
            $table->string('priority')->default('low');
            $table->string('cc')->nullable();
            $table->integer('assigned')->default('0');
            $table->integer('department_id')->default('1');
            $table->string('rating')->nullable();
            $table->string('ip_address')->nullable();
            $table->string('public_hash')->nullable();
            $table->string('public_name')->nullable();
            $table->string('public_email')->nullable();
            $table->string('organize')->nullable()->default('ticket');
            $table->string('date_closed')->nullable();
            $table->timestamp('updated_by_client_at')->nullable();
            $table->timestamp('first_employee_reply')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tickets');
    }
};
