<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Ticaga Version
    |--------------------------------------------------------------------------
    |
    | The current version of Ticaga. This is used for upgrade detection
    | and system health checks.
    |
    */

    'version' => '2.2.0',

    /*
    |--------------------------------------------------------------------------
    | Ticaga License Key
    |--------------------------------------------------------------------------
    |
    | This value is the license key for Ticaga, which will be used when
    | Ticaga wants to validate your license key.
    |
    */

    'key' => env('LICENSE_KEY', ''),

    /*
    |--------------------------------------------------------------------------
    | Ticaga API Version
    |--------------------------------------------------------------------------
    |
    | This value is the license key for Ticaga, which will be used when
    | Ticaga wants to validate your license key.
    |
    */

    'api' => env('API_VERSION', 'v2'),

    /*
    |--------------------------------------------------------------------------
    | Ticaga Responses Sorting
    |--------------------------------------------------------------------------
    |
    | This value is the sorting order for responses in Ticaga.
    | Default is ASC, this means that the last reply will be shown at the bottom.
    |
    */

    'sorting' => env('RESPONSE_SORTING', 'asc'),

    /*
    |--------------------------------------------------------------------------
    | Ticaga Ticket Design
    |--------------------------------------------------------------------------
    |
    | This value is the sorting order for tickets in Ticaga.
    | Default is DESC, which means that the latest tickets will be shown first.
    |
    */

    'design' => env('TICKET_DESIGN', 'classic'),

    /*
    |--------------------------------------------------------------------------
    | Third Party Systems
    |--------------------------------------------------------------------------
    |
    | These values are the links to your third party installations.
    |
    */

    'blesta'        => env('BLESTA_URI', ''),
    'whmcs'         => env('WHMCS_URI', ''),
    'clientexec'    => env('CLIENTEXEC_URI', ''),

    /*
    |--------------------------------------------------------------------------
    | Reverb WebSocket Configuration (Client-facing)
    |--------------------------------------------------------------------------
    |
    | These values configure how clients (browsers, widgets) connect to your
    | Reverb WebSocket server. This is separate from REVERB_SERVER_HOST which
    | is where the server binds internally (usually 0.0.0.0).
    |
    | Use your public domain name here, not 0.0.0.0!
    |
    */

    'reverb' => [
        'host' => env('REVERB_HOST') ?: parse_url(env('APP_URL'), PHP_URL_HOST),
        'port' => env('REVERB_PORT') ?: 443,
        'scheme' => env('REVERB_SCHEME') ?: 'https',
    ],

];