<?php

return [

    /*
    |--------------------------------------------------------------------------
    | File Attachments Enabled
    |--------------------------------------------------------------------------
    |
    | Master toggle for file attachment functionality. When disabled, no file
    | uploads will be allowed system-wide, regardless of department settings.
    |
    */

    'enabled' => env('ATTACHMENTS_ENABLED', true),

    /*
    |--------------------------------------------------------------------------
    | Maximum File Size
    |--------------------------------------------------------------------------
    |
    | Maximum allowed file size in megabytes (MB) for uploads.
    | This is the global default and can be overridden per department.
    |
    */

    'max_file_size_mb' => env('ATTACHMENTS_MAX_FILE_SIZE_MB', 10),

    /*
    |--------------------------------------------------------------------------
    | Maximum Files Per Ticket
    |--------------------------------------------------------------------------
    |
    | Maximum number of file attachments allowed per ticket.
    | This prevents abuse and controls storage usage.
    |
    */

    'max_files_per_ticket' => env('ATTACHMENTS_MAX_FILES_PER_TICKET', 10),

    /*
    |--------------------------------------------------------------------------
    | Allowed File Types (Whitelist)
    |--------------------------------------------------------------------------
    |
    | List of allowed file extensions and MIME types. When this array is not
    | empty, ONLY these file types will be accepted. Leave empty to allow all
    | types (except those in the blocked list).
    |
    | Examples: ['jpg', 'jpeg', 'png', 'gif', 'pdf', 'doc', 'docx', 'zip']
    |
    */

    'allowed_file_types' => [
        // Images
        'jpg', 'jpeg', 'png', 'gif', 'bmp', 'webp', 'svg',
        'image/jpeg', 'image/png', 'image/gif', 'image/bmp', 'image/webp', 'image/svg+xml',

        // Documents
        'pdf', 'doc', 'docx', 'xls', 'xlsx', 'ppt', 'pptx', 'txt', 'rtf', 'odt', 'ods',
        'application/pdf',
        'application/msword',
        'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
        'application/vnd.ms-excel',
        'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
        'application/vnd.ms-powerpoint',
        'application/vnd.openxmlformats-officedocument.presentationml.presentation',
        'text/plain',

        // Archives
        'zip', 'rar', '7z', 'tar', 'gz',
        'application/zip',
        'application/x-rar-compressed',
        'application/x-7z-compressed',

        // Media
        'mp3', 'mp4', 'avi', 'mov', 'wmv',
        'audio/mpeg',
        'video/mp4',
        'video/x-msvideo',
        'video/quicktime',
    ],

    /*
    |--------------------------------------------------------------------------
    | Blocked File Types (Blacklist)
    |--------------------------------------------------------------------------
    |
    | List of blocked file extensions and MIME types. These file types will
    | be rejected regardless of the whitelist setting. Useful for security.
    |
    | Examples: ['exe', 'bat', 'sh', 'php', 'js']
    |
    */

    'blocked_file_types' => [
        // Executables and scripts (security risk)
        'exe', 'bat', 'cmd', 'com', 'sh', 'bash',
        'application/x-msdownload',
        'application/x-sh',

        // Server-side scripts
        'php', 'php3', 'php4', 'php5', 'phtml', 'asp', 'aspx', 'jsp',
        'application/x-httpd-php',

        // Potentially dangerous files
        'dll', 'scr', 'vbs', 'jar',
    ],

    /*
    |--------------------------------------------------------------------------
    | Storage Disk
    |--------------------------------------------------------------------------
    |
    | The Laravel filesystem disk to use for storing attachments.
    | Options: 'local' (private), 'public', 's3', or any custom disk.
    |
    | Note: 'local' is recommended for security (files not publicly accessible)
    |
    */

    'storage_disk' => env('ATTACHMENTS_STORAGE_DISK', 'local'),

    /*
    |--------------------------------------------------------------------------
    | Storage Quota (Per User)
    |--------------------------------------------------------------------------
    |
    | Default storage quota per user in megabytes (MB). This can be overridden
    | at the department level or per individual user.
    |
    */

    'storage_quota_mb' => env('ATTACHMENTS_STORAGE_QUOTA_MB', 100),

    /*
    |--------------------------------------------------------------------------
    | Virus Scanning
    |--------------------------------------------------------------------------
    |
    | Enable virus scanning for uploaded files using ClamAV or similar.
    | Requires ClamAV to be installed and configured on the server.
    |
    | When enabled, files will be queued for scanning after upload.
    |
    */

    'require_virus_scan' => env('ATTACHMENTS_REQUIRE_VIRUS_SCAN', false),

    /*
    |--------------------------------------------------------------------------
    | ClamAV Socket Path
    |--------------------------------------------------------------------------
    |
    | Path to ClamAV socket for virus scanning. Only used if virus scanning
    | is enabled. Common paths: /var/run/clamav/clamd.sock (Linux),
    | /tmp/clamd.socket (macOS)
    |
    */

    'clamav_socket' => env('CLAMAV_SOCKET', '/var/run/clamav/clamd.sock'),

    /*
    |--------------------------------------------------------------------------
    | Thumbnail Generation
    |--------------------------------------------------------------------------
    |
    | Automatically generate thumbnails for image attachments.
    | Requires Intervention Image library to be installed.
    |
    */

    'enable_thumbnails' => env('ATTACHMENTS_ENABLE_THUMBNAILS', true),

    /*
    |--------------------------------------------------------------------------
    | Thumbnail Dimensions
    |--------------------------------------------------------------------------
    |
    | Width and height in pixels for generated thumbnails.
    | Images will be cropped to fit these dimensions.
    |
    */

    'thumbnail_width' => env('ATTACHMENTS_THUMBNAIL_WIDTH', 200),
    'thumbnail_height' => env('ATTACHMENTS_THUMBNAIL_HEIGHT', 200),

    /*
    |--------------------------------------------------------------------------
    | Signed URL Expiration
    |--------------------------------------------------------------------------
    |
    | Number of minutes that signed download URLs remain valid.
    | After this time, users will need to generate a new download link.
    |
    */

    'signed_url_expiration_minutes' => env('ATTACHMENTS_SIGNED_URL_EXPIRATION', 60),

    /*
    |--------------------------------------------------------------------------
    | Retention Policy
    |--------------------------------------------------------------------------
    |
    | Number of days to keep soft-deleted attachments before permanent deletion.
    | Set to 0 to disable automatic cleanup. Requires a scheduled task.
    |
    */

    'retention_days' => env('ATTACHMENTS_RETENTION_DAYS', 30),

    /*
    |--------------------------------------------------------------------------
    | Extract Email Attachments
    |--------------------------------------------------------------------------
    |
    | Automatically extract and save attachments from incoming emails when
    | tickets are created via email ingestion (IMAP).
    |
    */

    'extract_email_attachments' => env('ATTACHMENTS_EXTRACT_EMAIL', true),

    /*
    |--------------------------------------------------------------------------
    | Max Email Attachment Size
    |--------------------------------------------------------------------------
    |
    | Maximum size in MB for attachments extracted from emails. This can be
    | different from the upload limit to handle large email attachments.
    |
    */

    'max_email_attachment_size_mb' => env('ATTACHMENTS_MAX_EMAIL_SIZE_MB', 25),

];
