<?php

namespace App\View\Components;

use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;

class TicagaButton extends Component
{
    /**
     * Create a new component instance.
     */
    public function __construct(
        public ?string $href = null,
        public ?string $icon = null,
        public ?string $iconTrailing = null,
        public string $size = 'md',
        public string $variant = 'primary',
        public string $type = 'button',
    ) {
        //
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        return view('components.ticaga-button');
    }
}
