<?php

namespace App\Providers;

use Illuminate\Support\Facades\Broadcast;
use Illuminate\Support\ServiceProvider;

class BroadcastServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        // Remove 'auth' middleware to allow guest users (for Live Chat widget)
        // Channel authorization is handled in routes/channels.php
        // Custom middleware adds origin-aware CORS headers for broadcasting/auth
        Broadcast::routes(['middleware' => ['web', 'livechat.cors']]);

        require base_path('routes/channels.php');
    }
}
